"use strict";
cc._RF.push(module, 'b1a69KoXhxBsrqlZWs8cLmk', 'MapSub');
// Script/MapSub.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu;
var BlockSize = 180; //长宽相等
var AvatarSizeOther = 40;
var AvatarSizeMine = 100;
var BuildingZindex = 1;
var AvatarZindex = 2;
var ScreenRect = cc.rect();
var RequestDistance = 500;
var MapSub = /** @class */ (function (_super) {
    __extends(MapSub, _super);
    function MapSub() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.map_size = 50;
        _this.fristPos = cc.v2();
        _this.indexPosMap = [];
        _this.myNo = 0;
        _this.data = null;
        _this.subMapId = null;
        _this.userBlocks = [];
        _this.exsitPoses = [];
        _this.lastRequestPos = cc.v2();
        _this.resNo = 1;
        _this.blockId = null;
        _this.mapScroll = null;
        _this.startPoint = cc.v2();
        _this.subMapBlockId = "";
        return _this;
    }
    MapSub.prototype.onLoad = function () {
        var Origin = cc.view.getVisibleOrigin();
        var VisibleSize = cc.view.getVisibleSize();
        ScreenRect = cc.rect(Origin.x, Origin.y, VisibleSize.width, VisibleSize.height);
    };
    MapSub.prototype.start = function () {
        // //test use
        this.setMapView("431735834161842745", "431839989634959963", {
            "server_ts": 1667182984, "castle": { "block_id": "431840300718096386", "no": 1, "position_x": 0, "position_y": 0 },
            "dispatch_count": 26, "map_size": 10
        }, 1);
    };
    MapSub.prototype.onDestroy = function () {
    };
    MapSub.prototype.setMapView = function (blockId, subMapId, data, no) {
        var _this = this;
        // console.log("setMapData:", blockId, subMapId, JSON.stringify(data))
        this.blockId = blockId;
        this.subMapId = subMapId;
        this.data = data;
        this.resNo = no;
        this.map_size = data === null || data === void 0 ? void 0 : data.map_size;
        var castle = data === null || data === void 0 ? void 0 : data.castle;
        this.myNo = (castle === null || castle === void 0 ? void 0 : castle.no) || 0;
        var position_x = (castle === null || castle === void 0 ? void 0 : castle.position_x) || 0;
        var position_y = (castle === null || castle === void 0 ? void 0 : castle.position_y) || 0;
        this.subMapBlockId = (castle === null || castle === void 0 ? void 0 : castle.block_id) || "";
        this.setIndexPosMap();
        this.setMap();
        this.scheduleOnce(function () {
            _this.toBlockView(position_x, position_y);
        });
    };
    MapSub.prototype.setIndexPosMap = function () {
        for (var index = 1; index <= this.map_size * this.map_size; index++) {
            var x = this.GetPositionXByIndex(index);
            var y = this.GetPositionYByIndex(index);
            // console.log("index:", index,x,y)
            this.indexPosMap.push(cc.v2(x, y));
        }
    };
    MapSub.prototype.setMap = function () {
        var size = BlockSize * this.map_size;
        this.node.setContentSize(size + BlockSize * 2, size + BlockSize * 2);
        this.node.parent.setContentSize(this.node.getContentSize());
        var firstFactor = BlockSize / 2 * (this.map_size - 1);
        this.fristPos = cc.v2(-firstFactor, firstFactor);
        this.startPoint.x = size / 2 - BlockSize;
        this.startPoint.y = -(this.startPoint.x - 420);
        //装饰用不参与实际格子坐标计算
        for (var y = -1; y < this.map_size + 1; y++) {
            for (var x = -1; x < this.map_size + 1; x++) {
                // console.log("setMap:", x, y)
                if (x === -1 || y === -1 || x === this.map_size || y === this.map_size) {
                    this.addBlock(x, y, -1);
                }
            }
        }
        for (var y = 0; y < this.map_size; y++) {
            for (var x = 0; x < this.map_size; x++) {
                // console.log("setMap:", x, y)
                var no = this.getNoForPos(x, y);
                this.addBlock(x, y, no);
            }
        }
    };
    MapSub.prototype.addBlock = function (x, y, no) {
        var posX = this.fristPos.x + x * BlockSize;
        var posY = this.fristPos.y - y * BlockSize;
        var node = new cc.Node();
        this.node.addChild(node);
        node.name = 'block' + x + '_' + y;
        node.setPosition(posX, posY);
        if (no > 0 && no % 7 !== 0) {
            this.userBlocks.push(node);
        }
        //// console.log("addBlock:", x, y, sp.spriteFrame.name)
        /*--- test use ----*/
        var labNo = new cc.Node();
        labNo.zIndex = 100;
        var lab = labNo.addComponent(cc.Label);
        lab.fontSize = 30;
        lab.string = x + "," + y;
        labNo.setPosition(posX, posY);
        this.node.addChild(labNo);
    };
    MapSub.prototype.GetPositionXByIndex = function (index) {
        var n = Math.ceil(Math.sqrt(index));
        var layerOuterStartNo = Math.pow((n - 1), 2) + 1;
        var layerOuterEndNo = Math.pow((n - 1), 2) + n;
        if (layerOuterStartNo <= index && index <= layerOuterEndNo) {
            return n - 1;
        }
        return n - (index - layerOuterEndNo) - 1;
    };
    MapSub.prototype.GetPositionYByIndex = function (index) {
        var n = Math.ceil(Math.sqrt(index));
        var layerOuterStartNo = Math.pow(n, 2) - (n - 1);
        var layerOuterEndNo = Math.pow(n, 2);
        if (layerOuterStartNo <= index && index <= layerOuterEndNo) {
            return n - 1;
        }
        return n - (layerOuterStartNo - index) - 1;
    };
    MapSub.prototype.getNoForPos = function (x, y) {
        for (var index = 0; index < this.indexPosMap.length; index++) {
            var pos = this.indexPosMap[index];
            if (pos.x === x && pos.y === y) {
                return index + 1;
            }
        }
        return 0;
    };
    MapSub.prototype.toBlockView = function (x, y, duration) {
        if (duration === void 0) { duration = 0; }
        // console.log("toBlockView:", this.startPoint.x, this.startPoint.y, x, y)
        if (this.mapScroll) {
            this.mapScroll.node.setPosition(this.startPoint.x - 180 * x, this.startPoint.y + y * 180);
        }
    };
    MapSub.prototype.moveMap = function (pos) {
    };
    MapSub = __decorate([
        ccclass,
        menu('map/MapSub')
    ], MapSub);
    return MapSub;
}(cc.Component));
exports.default = MapSub;

cc._RF.pop();