
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/MapSub.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, 'b1a69KoXhxBsrqlZWs8cLmk', 'MapSub');
// Script/MapSub.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu;
var BlockSize = 180; //长宽相等
var AvatarSizeOther = 40;
var AvatarSizeMine = 100;
var BuildingZindex = 1;
var AvatarZindex = 2;
var ScreenRect = cc.rect();
var RequestDistance = 500;
var MapSub = /** @class */ (function (_super) {
    __extends(MapSub, _super);
    function MapSub() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.map_size = 50;
        _this.fristPos = cc.v2();
        _this.indexPosMap = [];
        _this.myNo = 0;
        _this.data = null;
        _this.subMapId = null;
        _this.userBlocks = [];
        _this.exsitPoses = [];
        _this.lastRequestPos = cc.v2();
        _this.resNo = 1;
        _this.blockId = null;
        _this.mapScroll = null;
        _this.startPoint = cc.v2();
        _this.subMapBlockId = "";
        return _this;
    }
    MapSub.prototype.onLoad = function () {
        var Origin = cc.view.getVisibleOrigin();
        var VisibleSize = cc.view.getVisibleSize();
        ScreenRect = cc.rect(Origin.x, Origin.y, VisibleSize.width, VisibleSize.height);
    };
    MapSub.prototype.start = function () {
        // //test use
        this.setMapView("431735834161842745", "431839989634959963", {
            "server_ts": 1667182984, "castle": { "block_id": "431840300718096386", "no": 1, "position_x": 0, "position_y": 0 },
            "dispatch_count": 26, "map_size": 10
        }, 1);
    };
    MapSub.prototype.onDestroy = function () {
    };
    MapSub.prototype.setMapView = function (blockId, subMapId, data, no) {
        var _this = this;
        // console.log("setMapData:", blockId, subMapId, JSON.stringify(data))
        this.blockId = blockId;
        this.subMapId = subMapId;
        this.data = data;
        this.resNo = no;
        this.map_size = data === null || data === void 0 ? void 0 : data.map_size;
        var castle = data === null || data === void 0 ? void 0 : data.castle;
        this.myNo = (castle === null || castle === void 0 ? void 0 : castle.no) || 0;
        var position_x = (castle === null || castle === void 0 ? void 0 : castle.position_x) || 0;
        var position_y = (castle === null || castle === void 0 ? void 0 : castle.position_y) || 0;
        this.subMapBlockId = (castle === null || castle === void 0 ? void 0 : castle.block_id) || "";
        this.setIndexPosMap();
        this.setMap();
        this.scheduleOnce(function () {
            _this.toBlockView(position_x, position_y);
        });
    };
    MapSub.prototype.setIndexPosMap = function () {
        for (var index = 1; index <= this.map_size * this.map_size; index++) {
            var x = this.GetPositionXByIndex(index);
            var y = this.GetPositionYByIndex(index);
            // console.log("index:", index,x,y)
            this.indexPosMap.push(cc.v2(x, y));
        }
    };
    MapSub.prototype.setMap = function () {
        var size = BlockSize * this.map_size;
        this.node.setContentSize(size + BlockSize * 2, size + BlockSize * 2);
        this.node.parent.setContentSize(this.node.getContentSize());
        var firstFactor = BlockSize / 2 * (this.map_size - 1);
        this.fristPos = cc.v2(-firstFactor, firstFactor);
        this.startPoint.x = size / 2 - BlockSize;
        this.startPoint.y = -(this.startPoint.x - 420);
        //装饰用不参与实际格子坐标计算
        for (var y = -1; y < this.map_size + 1; y++) {
            for (var x = -1; x < this.map_size + 1; x++) {
                // console.log("setMap:", x, y)
                if (x === -1 || y === -1 || x === this.map_size || y === this.map_size) {
                    this.addBlock(x, y, -1);
                }
            }
        }
        for (var y = 0; y < this.map_size; y++) {
            for (var x = 0; x < this.map_size; x++) {
                // console.log("setMap:", x, y)
                var no = this.getNoForPos(x, y);
                this.addBlock(x, y, no);
            }
        }
    };
    MapSub.prototype.addBlock = function (x, y, no) {
        var posX = this.fristPos.x + x * BlockSize;
        var posY = this.fristPos.y - y * BlockSize;
        var node = new cc.Node();
        this.node.addChild(node);
        node.name = 'block' + x + '_' + y;
        node.setPosition(posX, posY);
        if (no > 0 && no % 7 !== 0) {
            this.userBlocks.push(node);
        }
        //// console.log("addBlock:", x, y, sp.spriteFrame.name)
        /*--- test use ----*/
        var labNo = new cc.Node();
        labNo.zIndex = 100;
        var lab = labNo.addComponent(cc.Label);
        lab.fontSize = 30;
        lab.string = x + "," + y;
        labNo.setPosition(posX, posY);
        this.node.addChild(labNo);
    };
    MapSub.prototype.GetPositionXByIndex = function (index) {
        var n = Math.ceil(Math.sqrt(index));
        var layerOuterStartNo = Math.pow((n - 1), 2) + 1;
        var layerOuterEndNo = Math.pow((n - 1), 2) + n;
        if (layerOuterStartNo <= index && index <= layerOuterEndNo) {
            return n - 1;
        }
        return n - (index - layerOuterEndNo) - 1;
    };
    MapSub.prototype.GetPositionYByIndex = function (index) {
        var n = Math.ceil(Math.sqrt(index));
        var layerOuterStartNo = Math.pow(n, 2) - (n - 1);
        var layerOuterEndNo = Math.pow(n, 2);
        if (layerOuterStartNo <= index && index <= layerOuterEndNo) {
            return n - 1;
        }
        return n - (layerOuterStartNo - index) - 1;
    };
    MapSub.prototype.getNoForPos = function (x, y) {
        for (var index = 0; index < this.indexPosMap.length; index++) {
            var pos = this.indexPosMap[index];
            if (pos.x === x && pos.y === y) {
                return index + 1;
            }
        }
        return 0;
    };
    MapSub.prototype.toBlockView = function (x, y, duration) {
        if (duration === void 0) { duration = 0; }
        // console.log("toBlockView:", this.startPoint.x, this.startPoint.y, x, y)
        if (this.mapScroll) {
            this.mapScroll.node.setPosition(this.startPoint.x - 180 * x, this.startPoint.y + y * 180);
        }
    };
    MapSub.prototype.moveMap = function (pos) {
    };
    MapSub = __decorate([
        ccclass,
        menu('map/MapSub')
    ], MapSub);
    return MapSub;
}(cc.Component));
exports.default = MapSub;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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