"use strict";
cc._RF.push(module, 'e4705kuXlRIR7TMoSqhaT8Q', 'MapScroll');
// Script/MapScroll.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, menu = _a.menu;
/**
 * 地图移动，缩放功能
 */
var MapScroll = /** @class */ (function (_super) {
    __extends(MapScroll, _super);
    function MapScroll() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.mapOrigin = cc.v2();
        _this.moveCallBack = null;
        _this.scaleCallBack = null;
        _this.scaleConetentMin = 0.2;
        _this.scaleConetentMax = 1.5;
        _this.isCanDrag = true;
        return _this;
    }
    MapScroll.prototype.onLoad = function () {
        this.node.on(cc.Node.EventType.TOUCH_START, this.touchBegin, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.touchMove, this);
        this.node.on(cc.Node.EventType.TOUCH_END, this.touchEnd, this);
        this.node.on(cc.Node.EventType.TOUCH_CANCEL, this.touchEnd, this);
        this.updateMapOrgin();
        this.setSaclePostion();
        // this.node.on(cc.Node.EventType.MOUSE_WHEEL, function (event) {
        // })
    };
    MapScroll.prototype.start = function () {
    };
    MapScroll.prototype.setSaclePostion = function () {
        // 修正锚点(按当前的位置计算新锚点后在缩放) 否则会按照0.5 0.5放大
        var touchPoint1 = cc.v2(0, 100);
        var touchPoint2 = cc.v2(0, -100);
        var pointVec1 = touchPoint1.sub(this.mapOrigin);
        var pointVec2 = touchPoint2.sub(this.mapOrigin);
        var relMidx = (pointVec1.x + pointVec2.x) / 2;
        var relMidy = (pointVec1.y + pointVec2.y) / 2;
        var anchorX = relMidx / (this.node.width * this.node.scale);
        var anchorY = relMidy / (this.node.height * this.node.scale);
        var absMidx = (touchPoint2.x + touchPoint1.x) / 2;
        var absMidy = (touchPoint2.y + touchPoint1.y) / 2;
        this.node.anchorX = anchorX;
        this.node.anchorY = anchorY;
        this.node.x = absMidx;
        this.node.y = absMidy;
        // console.log('setSaclePostion:', this.mapOrigin.x, this.mapOrigin.y, anchorX, anchorY, absMidx, absMidy)
    };
    // scorllView content touch
    MapScroll.prototype.touchBegin = function (event) {
        // console.log("touchBegin:", event.getTouches().length, event.getID())
        if (event.getID() > 0) {
            return false;
        }
    };
    MapScroll.prototype.touchMove = function (event) {
        var touches = event.getTouches();
        if (touches.length >= 2) { // 缩放地图操作
            var touch1 = touches[0];
            var touch2 = touches[1];
            var delta1 = touch1.getDelta();
            var delta2 = touch2.getDelta();
            // 得到当前两触摸点 转到parent下坐标
            var touchPoint1 = this.node.parent.convertToNodeSpaceAR(touch1.getLocation());
            var touchPoint2 = this.node.parent.convertToNodeSpaceAR(touch2.getLocation());
            // 转换为坐标 进行向量计算
            touchPoint1 = cc.v2(touchPoint1.x, touchPoint1.y);
            touchPoint2 = cc.v2(touchPoint2.x, touchPoint2.y);
            // 两触摸点与原点的差向量，pointVec1和pointVec2是相对于bgSprite的位置
            var pointVec1 = touchPoint1.sub(this.mapOrigin);
            var pointVec2 = touchPoint2.sub(this.mapOrigin);
            // 两触摸点的相对中点
            var relMidx = (pointVec1.x + pointVec2.x) / 2;
            var relMidy = (pointVec1.y + pointVec2.y) / 2;
            // 计算bgSprite的锚点
            var anchorX = relMidx / (this.node.width * this.node.scale);
            var anchorY = relMidy / (this.node.height * this.node.scale);
            // 相对屏幕的中点
            var absMidx = (touchPoint2.x + touchPoint1.x) / 2;
            var absMidy = (touchPoint2.y + touchPoint1.y) / 2;
            // 重设bgSprite锚点和位置
            this.node.anchorX = anchorX;
            this.node.anchorY = anchorY;
            this.node.x = absMidx;
            this.node.y = absMidy;
            // console.log('anchorX anchorY absMidx absMidy', anchorX.toFixed(2), anchorY.toFixed(2), absMidx.toFixed(2), absMidy.toFixed(2),
            //     this.node.anchorX.toFixed(2), this.node.anchorY.toFixed(2), this.node.scaleX.toFixed(2),
            //     this.node.scaleY.toFixed(2))
            // 缩放
            var distance = touchPoint1.sub(touchPoint2);
            var delta = delta1.sub(delta2);
            var scale = 1;
            if (Math.abs(distance.x) > Math.abs(distance.y)) {
                scale = (distance.x + delta.x * 0.5) / distance.x * this.node.scale;
            }
            else {
                scale = (distance.y + delta.y * 0.5) / distance.y * this.node.scale;
            }
            this.node.scale = scale < this.scaleConetentMin
                ? this.scaleConetentMin
                : scale > this.scaleConetentMax ? this.scaleConetentMax : scale;
            if (this.scaleCallBack) {
                this.scaleCallBack(this.node.scale);
            }
            // 更新原点位置
            this.mapOrigin = cc.v2(this.node.x, this.node.y).sub(cc.v2(this.node.width * anchorX * this.node.scaleX, this.node.height * anchorY * this.node.scaleY));
            // console.log("updateMapOrgin222:", this.mapOrigin.x.toFixed(), this.mapOrigin.y.toFixed())
        }
        else if (event.getTouches().length === 1) { // 拖动地图
            if (this.isCanDrag) {
                if (event.getID() > 0) {
                    return;
                }
                var location = event.getLocation();
                var previousLocation = event.getPreviousLocation();
                var distance = cc.Vec2.distance(previousLocation, location);
                // console.log("distance:", distance)
                if (distance > 2) {
                    var delta = event.getDelta();
                    this.node.x += delta.x;
                    this.node.y += delta.y;
                    // console.log("this.node.x :", this.node.x, this.node.y)
                    if (this.moveCallBack) {
                        this.moveCallBack(this.node.getPosition());
                    }
                }
            }
        }
        this.goboundary();
        this.updateMapOrgin();
    };
    MapScroll.prototype.touchEnd = function (event) {
    };
    MapScroll.prototype.updateMapOrgin = function () {
        this.mapOrigin = cc.v2(this.node.position).sub(cc.v2(this.node.width * this.node.anchorX * this.node.scaleX, this.node.height * this.node.anchorY * this.node.scaleY));
        // console.log("updateMapOrgin111:", this.mapOrigin.x.toFixed(), this.mapOrigin.y.toFixed(), this.node.x.toFixed(),
        // this.node.y.toFixed(), this.node.width.toFixed(), this.node.height.toFixed(), this.node.anchorX.toFixed(),
        // this.node.anchorY.toFixed())
    };
    MapScroll.prototype.goboundary = function () {
        var windowSize = cc.view.getVisibleSize();
        var minScale = Math.ceil(windowSize.height / this.node.height);
        var _map_scale = this.node.scale;
        var anchorPoint_after = this.node.getAnchorPoint();
        var posX_left = windowSize.width / 2 - (this.node.width * anchorPoint_after.x * _map_scale - this.node.getPosition().x);
        if (posX_left > 0) {
            var posx = (this.node.width * anchorPoint_after.x * _map_scale) - windowSize.width / 2;
            this.node.setPosition(posx, this.node.y);
        }
        // 下侧空白距离
        var posX_bottom = windowSize.height / 2 - (this.node.height * anchorPoint_after.y * _map_scale - this.node.getPosition().y);
        if (posX_bottom > 0) {
            var posy = (this.node.height * anchorPoint_after.y * _map_scale) - windowSize.height / 2;
            this.node.setPosition(this.node.x, posy);
        }
        // 右侧空白距离
        var posX_right = windowSize.width / 2 - (this.node.width * (1 - anchorPoint_after.x) * _map_scale + this.node.getPosition().x);
        if (posX_right > 0) {
            var posx = windowSize.width / 2 - (this.node.width * (1 - anchorPoint_after.x) * _map_scale);
            this.node.setPosition(posx, this.node.y);
        }
        // 上侧空白距离
        var posX_top = windowSize.height / 2 - (this.node.height * (1 - anchorPoint_after.y) * _map_scale + this.node.getPosition().y);
        if (posX_top > 0) {
            var posy = windowSize.height / 2 - (this.node.height * (1 - anchorPoint_after.y) * _map_scale);
            this.node.setPosition(this.node.x, posy);
        }
    };
    MapScroll.prototype.setMoveCallBack = function (callBack) {
        this.moveCallBack = callBack;
    };
    MapScroll.prototype.setScaleCallBack = function (callBack) {
        this.scaleCallBack = callBack;
    };
    MapScroll.prototype.setScaleScope = function (minScale, maxScale) {
        this.scaleConetentMin = minScale;
        this.scaleConetentMax = maxScale;
    };
    __decorate([
        property({ tooltip: "是否开启拖动" })
    ], MapScroll.prototype, "isCanDrag", void 0);
    MapScroll = __decorate([
        ccclass,
        menu('map/MapScroll')
    ], MapScroll);
    return MapScroll;
}(cc.Component));
exports.default = MapScroll;

cc._RF.pop();