// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property(cc.Button)
    btn: cc.Button = null;

    @property(cc.Node)
    area: cc.Node = null;
    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        this.area.once(cc.Node.EventType.POSITION_CHANGED, () => {
            console.log('position changed');
        })
        this.area.once(cc.Node.EventType.SIZE_CHANGED, () => {
            console.log('size changed');
        })
    }

    onBtnClick() {
        this.area.width += 10;
        this.area.setPosition(this.area.position.add(cc.v3(10, 0, 0)))
    }
}
