import { _decorator, assetManager, Component, Event, instantiate, Node, Prefab } from 'cc';
const { ccclass, property } = _decorator;

class Perf {
	m_times: number[] = []

	clear() {
		this.m_times = []
	}

	capture() {
		this.m_times.push(Date.now())
	}

	dump(prefix: string) {
		let str = ""
		for (let i = 0; i + 1 < this.m_times.length; ++i) {
			if (str) str += ","
			str += `${this.m_times[i+1] - this.m_times[i]}`
		}
		console.info(`${prefix}${str}`)
	}
}

@ccclass('MainScene')
export class MainScene extends Component {
	start() {
	}

	onClickAddChild(event: Event) {
		this.test_addChild()
	}

	test_addChild() {
		let bundleName = "club"
		let prefabPath = "prefabs/ClubTableBaseItem2"
		assetManager.loadBundle(bundleName, (err, bundle) => {
			if (!err) {
				bundle.load(prefabPath, Prefab, (err, prefab) => {
					if (!err) {
						let parent = this.node.getChildByPath("container")
						let perf = new Perf()
						let t = Date.now()
						for (let i = 0; i < 2; ++i) {
							perf.clear()
							perf.capture()
							let node = instantiate(prefab)
							perf.capture()
							parent.addChild(node)
							perf.capture()
							perf.dump(`time${i}:`)
						}
						console.info(`total took ${Date.now() - t} ms`)
						this.scheduleOnce(() => {
							parent.destroyAllChildren()
						}, 1)
					}
				})
			}
		})
	}
}
