import { Collider2D, Contact2DType, Prefab, RigidBody2D, instantiate, tween } from 'cc';
import { _decorator, Component, Node, PhysicsSystem2D, Vec2, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('demo')
export class demo extends Component {

    @property(Prefab)
    sub : Prefab = null;

    protected start(): void {
        let collider = this.node.getComponent(Collider2D);
        //console.log(collider)
        if(collider){
            collider.on(Contact2DType.BEGIN_CONTACT,this.colliderBack,this)

        }


    }

    colliderBack(self:Collider2D,other : Collider2D){
        let sub_node = instantiate(this.sub);
        sub_node.position = self.node.position;
        this.node.parent.addChild(sub_node);
        tween(sub_node)
            .to(3,{position : other.node.position})
            .start();

        console.log(other.node)

    }
   
}


