
import { _decorator, Component, Node, SkelAnimDataHub, SkeletalAnimation } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    @property({type: SkeletalAnimation})
    playerAnimation: SkeletalAnimation = null!;

    playerState: string = "";

    changeState: boolean = true;

    start () {
        // [3]
        this.schedule(() => {
            this.changeState = !this.changeState;
            this.count = 0;
        }, 5);
    }

    changeAnimation() {
        if (Math.random() > 0.5) {
            this.playAnimation("runHit");
        } else {
            this.playAnimation("run");
        }
    }

    playAnimation(name: string) {
        if (name != this.playerState) {
            console.warn("play", name);
            this.playerAnimation.crossFade(name, 0.3);
            this.playerState = name;
        }
    }

    count: number = 0;
    update (deltaTime: number) {
        // [4]
        if (this.changeState && this.count < 20) {
            this.changeAnimation();
            this.count++;
        }
    }
}