cc.Class({
    extends: cc.Component,

    properties: {
        movespeed:700,
    },

    onLoad () {
        this.left=false;
        this.right=false;

        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN,this.onKeyDown,this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP,this.onKeyUp,this);
    },

    start () {

    },

    update (dt) {
        if(this.left){
            this.node.x-=this.movespeed*dt;
        }else if(this.right){
            this.node.x+=this.movespeed*dt;
        }
    },

    onKeyDown(event){
        //设置对应按键按下发生的事件
        switch(event.keyCode){
            //按下A键
            case cc.macro.KEY.a:
            case cc.macro.KEY.left:
              this.left=true;
            break;
  
            case cc.macro.KEY.d:
            case cc.macro.KEY.right:
              this.right=true;
            break;
        }
    },
    
    onKeyUp(event){
        //设置按键抬起后的事件
        switch(event.keyCode){
            //按下A键
            case cc.macro.KEY.a:
            case cc.macro.KEY.left:
              this.left=false;
            break;
  
            case cc.macro.KEY.d:
            case cc.macro.KEY.right:
              this.right=false;
            break;
        }
    },
});
