/**
 * mask_bg 只用于位置移动
 */
const {ccclass, property} = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {   

    @property(cc.Node)
    mask_node:cc.Node = null;   

    @property({displayName:"遮罩是否反向",tooltip:"tips"})
    invert:boolean = false;

    @property({displayName:"超出区域是否显示",tooltip:"tips"})
    over_invert:boolean = false;
    
    onLoad () {
        let mask_node = this.mask_node;
        console.log(this.mask_node.opacity/255);
        mask_node.active = false;
        //1.获取位置大小
        let image_width = this.node.width;
        let image_height = this.node.height;        
        let mask_width = mask_node.width;
        let mask_height = mask_node.height;

        let x_mul = image_width/mask_width;
        let y_mul = image_height/mask_height;

        let x_offset = Math.abs(mask_node.x/image_width);
        let y_offset = Math.abs(mask_node.y/image_height);

        //this.mask_sprite.spriteFrame.getTexture

        let mask = this.node.getComponent(cc.Sprite).getMaterial(0);
        mask.setProperty("x_mul",x_mul); 
        mask.setProperty("y_mul",y_mul); 
        mask.setProperty("x_offset",x_offset); 
        mask.setProperty("y_offset",y_offset);        
        mask.setProperty("invert",this.invert); 
        mask.setProperty("over_invert",this.over_invert); 
        mask.setProperty("mask_a",this.mask_node.opacity/255);       
        mask.setProperty("texture_mask",mask_node.getComponent(cc.Sprite).spriteFrame.getTexture());
    }

    start () {

    }

    // update (dt) {}
}
