import { _decorator, Button, Color, Component, instantiate, Material, Node, Sprite, Vec4 } from 'cc';
const { ccclass, property } = _decorator;

/**
 */
@ccclass('SplitAndMerge')
export class SplitAndMerge extends Component {

    @property(Sprite)
    sprite: Sprite = null;

    @property(Sprite)
    sprite2: Sprite = null;

    @property(Button)
    button: Button = null;

    start() {

        
        // 3.8.7-win-073013版本 材质setProperty后隐藏后重新显示失效
        // 修复: https://github.com/cocos/cocos-engine/pull/18880

        let spMat = this.sprite.getMaterialInstance(0);
        spMat.setProperty("endColor", new Color(255, 0, 0, 255));

        let spMat2 = this.sprite2.getMaterialInstance(0);
        spMat2.setProperty("endColor", new Color(0, 0, 255, 255));
        
        this.button.node.on(Node.EventType.TOUCH_START, ()=>{
            this.sprite.node.active = !this.sprite.node.active;
            this.sprite2.node.active = !this.sprite2.node.active;
        })
    }

}


