
let TAG = "NetFrame";
const { ccclass, property } = cc._decorator;

// Object.values(cc.assetManager.assets._map).filter((a)=>!a.name.includes("builtin-"))
@ccclass
export default class NetFrame extends cc.Sprite {
    // 网络图片地址
    @property()
    url : string = "";
 
    // 显示的sprite大小
    @property( cc.size )
    size : cc.Size = new cc.Size( 0, 0 );
 
    // 默认图片
    private spFrame_ : cc.SpriteFrame = null;
 
    // 图片类型 0: 默认图； 1:加载图
    private isSpFrameType_ : number = 0;
 
    onLoad() {// 组建已经创建了，但是又执行了active, 会回调onLoad
        this.spFrame_ = this.spriteFrame;
        // this.addRef();
    }
 
    onDestroy(){
        this.decRef();
    }
    
    start() {
        // console.log('start url:', this.url);
        // this.loadFrame( this.url );
    }
 
    decRef(){
        cc.isValid(this.spriteFrame) && this.spriteFrame.decRef();
    }
 
    addRef(){
        cc.isValid(this.spriteFrame) && this.spriteFrame.addRef();
    }
 
    /**
     * 重置成原图，方便重复使用
     */
    reset() {
        // return;
        // 删除上次创建的sf
        // if( this.isSpFrameType_ != 0 && this.spriteFrame && cc.isValid( this.spriteFrame ) ) {
        //     this.spriteFrame.decRef();
        //     this.spriteFrame = null;
        // }
        this.decRef();
 
        // 还原默认图
        this.isSpFrameType_ = 0;
        this.spriteFrame = this.spFrame_;
        this.addRef();
    }
 
    /**
     * 加载网络图
     * @param url 网络图地址 
     * @param isUseWebOnLoad 判断原生平台是否使用web下载
     */
    loadFrame( url : string, defaultPath ?: string, isUseWebOnLoad ?: boolean, isReset ?: boolean, onSucc ?: (spe : cc.SpriteFrame) => void ) {
        if( !url ) {
            // cc.log(TAG, " loadFrame load err url is null ... ");
            if( isUseWebOnLoad ) cc.log(TAG, " loadFrame load url err url = 2222222222 ", url );
            if(defaultPath){
                this.loadLocal(defaultPath);
            }
            return;
        }
        // cc.log(TAG, " loadFrame load  ... " + url + " " + isitem);
 
        if( isReset ) this.reset();
        this.loadFramePng( url, defaultPath, isUseWebOnLoad, isReset, onSucc );
    }
 
    /**
     * 除了facebook，正常的都走这个逻辑
     * @param url 
     * @param defaultPath 
     * @param isUseWebOnLoad 
     * @param isReset 
     * @param onSucc 
     */
    loadFramePng = this.loadHeadUrl.bind( this );
 
    /**
     * 针对Facebook没有.png等后缀的图片地址
     * @param url 
     */
    loadFrameNoPng = this.loadHeadUrl.bind( this );
 
    loadLocal(defaultPath: string){
        let self = this;
        if(defaultPath){
            cc.resources.load(defaultPath, cc.SpriteFrame, (err, sp:cc.SpriteFrame) => {
                if(!err && sp){
                    self.decRef();
                    self.spriteFrame = sp;
                    self.addRef();
                    self.resetSize();
                }
            });
        }
    }
 
    /**
     * 圆形头像使用
     * @param url 
     * @param defaultPath 
     * @param isUseWebOnLoad 
     * @param isReset 
     * @param onSucc 
     */
    loadHeadUrl( url : string, defaultPath ?: string, isUseWebOnLoad ?: boolean, isReset ?: boolean, onSucc ?: (spe : cc.SpriteFrame) => void ) {
        if(!url){
            this.loadLocal(defaultPath);
            return;
        }
        let self = this;
        let ext = cc.path.extname(url).toLowerCase();
        if(!ext.length){
            ext = '.png';
        }
        cc.assetManager.loadRemote( url, {ext}, ( err, texture:cc.Texture2D) => {
            // 可能已经销毁
            if( !self || !cc.isValid( self ) ) {
                cc.log(TAG, " loadFrame load url err url = 33333333333 " );
                return;
            }
 
            if(err){
                cc.log(TAG, " loadFrame load url err url = " + url);
                self.loadLocal(defaultPath);
                return;
            }
 
            texture.addRef();
 
            self.decRef();
            self.spriteFrame = new cc.SpriteFrame(texture);
            self.addRef();
            texture.packable = false;
            // self.spriteFrame = spriteFrame;
            self.isSpFrameType_ = 1;
            self.resetSize();
            onSucc && onSucc(self.spriteFrame);
        });
    }
 
    resetSize(){
        //设置sprite的大小
        if( this.size.width == 0 && this.size.height == 0 ) {
            // 按照原图大小显示
            this.node.width = this.spriteFrame.getRect().width;
            this.node.height = this.spriteFrame.getRect().height;
        } else {
            // 按照设置的大小显示图片
            this.node.width = this.size.width;
            this.node.height = this.size.height;
        }
    }
 
    setSize(size : cc.Size){
        this.size = size;
        this.resetSize();
    }
 
}
