"use strict";
cc._RF.push(module, '1d5f27xgmNF6o0k/VT9YkjZ', 'NetFrame');
// Script/NetFrame.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var TAG = "NetFrame";
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
// Object.values(cc.assetManager.assets._map).filter((a)=>!a.name.includes("builtin-"))
var NetFrame = /** @class */ (function (_super) {
    __extends(NetFrame, _super);
    function NetFrame() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 网络图片地址
        _this.url = "";
        // 显示的sprite大小
        _this.size = new cc.Size(0, 0);
        // 默认图片
        _this.spFrame_ = null;
        // 图片类型 0: 默认图； 1:加载图
        _this.isSpFrameType_ = 0;
        /**
         * 除了facebook，正常的都走这个逻辑
         * @param url
         * @param defaultPath
         * @param isUseWebOnLoad
         * @param isReset
         * @param onSucc
         */
        _this.loadFramePng = _this.loadHeadUrl.bind(_this);
        /**
         * 针对Facebook没有.png等后缀的图片地址
         * @param url
         */
        _this.loadFrameNoPng = _this.loadHeadUrl.bind(_this);
        return _this;
    }
    NetFrame.prototype.onLoad = function () {
        this.spFrame_ = this.spriteFrame;
        // this.addRef();
    };
    NetFrame.prototype.onDestroy = function () {
        this.decRef();
    };
    NetFrame.prototype.start = function () {
        // console.log('start url:', this.url);
        // this.loadFrame( this.url );
    };
    NetFrame.prototype.decRef = function () {
        cc.isValid(this.spriteFrame) && this.spriteFrame.decRef();
    };
    NetFrame.prototype.addRef = function () {
        cc.isValid(this.spriteFrame) && this.spriteFrame.addRef();
    };
    /**
     * 重置成原图，方便重复使用
     */
    NetFrame.prototype.reset = function () {
        // return;
        // 删除上次创建的sf
        // if( this.isSpFrameType_ != 0 && this.spriteFrame && cc.isValid( this.spriteFrame ) ) {
        //     this.spriteFrame.decRef();
        //     this.spriteFrame = null;
        // }
        this.decRef();
        // 还原默认图
        this.isSpFrameType_ = 0;
        this.spriteFrame = this.spFrame_;
        this.addRef();
    };
    /**
     * 加载网络图
     * @param url 网络图地址
     * @param isUseWebOnLoad 判断原生平台是否使用web下载
     */
    NetFrame.prototype.loadFrame = function (url, defaultPath, isUseWebOnLoad, isReset, onSucc) {
        if (!url) {
            // cc.log(TAG, " loadFrame load err url is null ... ");
            if (isUseWebOnLoad)
                cc.log(TAG, " loadFrame load url err url = 2222222222 ", url);
            if (defaultPath) {
                this.loadLocal(defaultPath);
            }
            return;
        }
        // cc.log(TAG, " loadFrame load  ... " + url + " " + isitem);
        if (isReset)
            this.reset();
        this.loadFramePng(url, defaultPath, isUseWebOnLoad, isReset, onSucc);
    };
    NetFrame.prototype.loadLocal = function (defaultPath) {
        var self = this;
        if (defaultPath) {
            cc.resources.load(defaultPath, cc.SpriteFrame, function (err, sp) {
                if (!err && sp) {
                    self.decRef();
                    self.spriteFrame = sp;
                    self.addRef();
                    self.resetSize();
                }
            });
        }
    };
    /**
     * 圆形头像使用
     * @param url
     * @param defaultPath
     * @param isUseWebOnLoad
     * @param isReset
     * @param onSucc
     */
    NetFrame.prototype.loadHeadUrl = function (url, defaultPath, isUseWebOnLoad, isReset, onSucc) {
        if (!url) {
            this.loadLocal(defaultPath);
            return;
        }
        var self = this;
        var ext = cc.path.extname(url).toLowerCase();
        if (!ext.length) {
            ext = '.png';
        }
        cc.assetManager.loadRemote(url, { ext: ext }, function (err, texture) {
            // 可能已经销毁
            if (!self || !cc.isValid(self)) {
                cc.log(TAG, " loadFrame load url err url = 33333333333 ");
                return;
            }
            if (err) {
                cc.log(TAG, " loadFrame load url err url = " + url);
                self.loadLocal(defaultPath);
                return;
            }
            texture.addRef();
            self.decRef();
            self.spriteFrame = new cc.SpriteFrame(texture);
            self.addRef();
            texture.packable = false;
            // self.spriteFrame = spriteFrame;
            self.isSpFrameType_ = 1;
            self.resetSize();
            onSucc && onSucc(self.spriteFrame);
        });
    };
    NetFrame.prototype.resetSize = function () {
        //设置sprite的大小
        if (this.size.width == 0 && this.size.height == 0) {
            // 按照原图大小显示
            this.node.width = this.spriteFrame.getRect().width;
            this.node.height = this.spriteFrame.getRect().height;
        }
        else {
            // 按照设置的大小显示图片
            this.node.width = this.size.width;
            this.node.height = this.size.height;
        }
    };
    NetFrame.prototype.setSize = function (size) {
        this.size = size;
        this.resetSize();
    };
    __decorate([
        property()
    ], NetFrame.prototype, "url", void 0);
    __decorate([
        property(cc.size)
    ], NetFrame.prototype, "size", void 0);
    NetFrame = __decorate([
        ccclass
    ], NetFrame);
    return NetFrame;
}(cc.Sprite));
exports.default = NetFrame;

cc._RF.pop();