
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/NetFrame.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '1d5f27xgmNF6o0k/VT9YkjZ', 'NetFrame');
// Script/NetFrame.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
var TAG = "NetFrame";
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
// Object.values(cc.assetManager.assets._map).filter((a)=>!a.name.includes("builtin-"))
var NetFrame = /** @class */ (function (_super) {
    __extends(NetFrame, _super);
    function NetFrame() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        // 网络图片地址
        _this.url = "";
        // 显示的sprite大小
        _this.size = new cc.Size(0, 0);
        // 默认图片
        _this.spFrame_ = null;
        // 图片类型 0: 默认图； 1:加载图
        _this.isSpFrameType_ = 0;
        /**
         * 除了facebook，正常的都走这个逻辑
         * @param url
         * @param defaultPath
         * @param isUseWebOnLoad
         * @param isReset
         * @param onSucc
         */
        _this.loadFramePng = _this.loadHeadUrl.bind(_this);
        /**
         * 针对Facebook没有.png等后缀的图片地址
         * @param url
         */
        _this.loadFrameNoPng = _this.loadHeadUrl.bind(_this);
        return _this;
    }
    NetFrame.prototype.onLoad = function () {
        this.spFrame_ = this.spriteFrame;
        // this.addRef();
    };
    NetFrame.prototype.onDestroy = function () {
        this.decRef();
    };
    NetFrame.prototype.start = function () {
        // console.log('start url:', this.url);
        // this.loadFrame( this.url );
    };
    NetFrame.prototype.decRef = function () {
        cc.isValid(this.spriteFrame) && this.spriteFrame.decRef();
    };
    NetFrame.prototype.addRef = function () {
        cc.isValid(this.spriteFrame) && this.spriteFrame.addRef();
    };
    /**
     * 重置成原图，方便重复使用
     */
    NetFrame.prototype.reset = function () {
        // return;
        // 删除上次创建的sf
        // if( this.isSpFrameType_ != 0 && this.spriteFrame && cc.isValid( this.spriteFrame ) ) {
        //     this.spriteFrame.decRef();
        //     this.spriteFrame = null;
        // }
        this.decRef();
        // 还原默认图
        this.isSpFrameType_ = 0;
        this.spriteFrame = this.spFrame_;
        this.addRef();
    };
    /**
     * 加载网络图
     * @param url 网络图地址
     * @param isUseWebOnLoad 判断原生平台是否使用web下载
     */
    NetFrame.prototype.loadFrame = function (url, defaultPath, isUseWebOnLoad, isReset, onSucc) {
        if (!url) {
            // cc.log(TAG, " loadFrame load err url is null ... ");
            if (isUseWebOnLoad)
                cc.log(TAG, " loadFrame load url err url = 2222222222 ", url);
            if (defaultPath) {
                this.loadLocal(defaultPath);
            }
            return;
        }
        // cc.log(TAG, " loadFrame load  ... " + url + " " + isitem);
        if (isReset)
            this.reset();
        this.loadFramePng(url, defaultPath, isUseWebOnLoad, isReset, onSucc);
    };
    NetFrame.prototype.loadLocal = function (defaultPath) {
        var self = this;
        if (defaultPath) {
            cc.resources.load(defaultPath, cc.SpriteFrame, function (err, sp) {
                if (!err && sp) {
                    self.decRef();
                    self.spriteFrame = sp;
                    self.addRef();
                    self.resetSize();
                }
            });
        }
    };
    /**
     * 圆形头像使用
     * @param url
     * @param defaultPath
     * @param isUseWebOnLoad
     * @param isReset
     * @param onSucc
     */
    NetFrame.prototype.loadHeadUrl = function (url, defaultPath, isUseWebOnLoad, isReset, onSucc) {
        if (!url) {
            this.loadLocal(defaultPath);
            return;
        }
        var self = this;
        var ext = cc.path.extname(url).toLowerCase();
        if (!ext.length) {
            ext = '.png';
        }
        cc.assetManager.loadRemote(url, { ext: ext }, function (err, texture) {
            // 可能已经销毁
            if (!self || !cc.isValid(self)) {
                cc.log(TAG, " loadFrame load url err url = 33333333333 ");
                return;
            }
            if (err) {
                cc.log(TAG, " loadFrame load url err url = " + url);
                self.loadLocal(defaultPath);
                return;
            }
            texture.addRef();
            self.decRef();
            self.spriteFrame = new cc.SpriteFrame(texture);
            self.addRef();
            texture.packable = false;
            // self.spriteFrame = spriteFrame;
            self.isSpFrameType_ = 1;
            self.resetSize();
            onSucc && onSucc(self.spriteFrame);
        });
    };
    NetFrame.prototype.resetSize = function () {
        //设置sprite的大小
        if (this.size.width == 0 && this.size.height == 0) {
            // 按照原图大小显示
            this.node.width = this.spriteFrame.getRect().width;
            this.node.height = this.spriteFrame.getRect().height;
        }
        else {
            // 按照设置的大小显示图片
            this.node.width = this.size.width;
            this.node.height = this.size.height;
        }
    };
    NetFrame.prototype.setSize = function (size) {
        this.size = size;
        this.resetSize();
    };
    __decorate([
        property()
    ], NetFrame.prototype, "url", void 0);
    __decorate([
        property(cc.size)
    ], NetFrame.prototype, "size", void 0);
    NetFrame = __decorate([
        ccclass
    ], NetFrame);
    return NetFrame;
}(cc.Sprite));
exports.default = NetFrame;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFzc2V0cy9TY3JpcHQvTmV0RnJhbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQ0EsSUFBSSxHQUFHLEdBQUcsVUFBVSxDQUFDO0FBQ2YsSUFBQSxLQUF3QixFQUFFLENBQUMsVUFBVSxFQUFuQyxPQUFPLGFBQUEsRUFBRSxRQUFRLGNBQWtCLENBQUM7QUFFNUMsdUZBQXVGO0FBRXZGO0lBQXNDLDRCQUFTO0lBQS9DO1FBQUEscUVBdUtDO1FBdEtHLFNBQVM7UUFFVCxTQUFHLEdBQVksRUFBRSxDQUFDO1FBRWxCLGNBQWM7UUFFZCxVQUFJLEdBQWEsSUFBSSxFQUFFLENBQUMsSUFBSSxDQUFFLENBQUMsRUFBRSxDQUFDLENBQUUsQ0FBQztRQUVyQyxPQUFPO1FBQ0MsY0FBUSxHQUFvQixJQUFJLENBQUM7UUFFekMscUJBQXFCO1FBQ2Isb0JBQWMsR0FBWSxDQUFDLENBQUM7UUE4RHBDOzs7Ozs7O1dBT0c7UUFDSCxrQkFBWSxHQUFHLEtBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFFLEtBQUksQ0FBRSxDQUFDO1FBRTdDOzs7V0FHRztRQUNILG9CQUFjLEdBQUcsS0FBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUUsS0FBSSxDQUFFLENBQUM7O0lBOEVuRCxDQUFDO0lBeEpHLHlCQUFNLEdBQU47UUFDSSxJQUFJLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUM7UUFDakMsaUJBQWlCO0lBQ3JCLENBQUM7SUFFRCw0QkFBUyxHQUFUO1FBQ0ksSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBQ2xCLENBQUM7SUFFRCx3QkFBSyxHQUFMO1FBQ0ksdUNBQXVDO1FBQ3ZDLDhCQUE4QjtJQUNsQyxDQUFDO0lBRUQseUJBQU0sR0FBTjtRQUNJLEVBQUUsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxFQUFFLENBQUM7SUFDOUQsQ0FBQztJQUVELHlCQUFNLEdBQU47UUFDSSxFQUFFLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBQzlELENBQUM7SUFFRDs7T0FFRztJQUNILHdCQUFLLEdBQUw7UUFDSSxVQUFVO1FBQ1YsWUFBWTtRQUNaLHlGQUF5RjtRQUN6RixpQ0FBaUM7UUFDakMsK0JBQStCO1FBQy9CLElBQUk7UUFDSixJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7UUFFZCxRQUFRO1FBQ1IsSUFBSSxDQUFDLGNBQWMsR0FBRyxDQUFDLENBQUM7UUFDeEIsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDO1FBQ2pDLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUNsQixDQUFDO0lBRUQ7Ozs7T0FJRztJQUNILDRCQUFTLEdBQVQsVUFBVyxHQUFZLEVBQUUsV0FBcUIsRUFBRSxjQUF5QixFQUFFLE9BQWtCLEVBQUUsTUFBd0M7UUFDbkksSUFBSSxDQUFDLEdBQUcsRUFBRztZQUNQLHVEQUF1RDtZQUN2RCxJQUFJLGNBQWM7Z0JBQUcsRUFBRSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEVBQUUsMkNBQTJDLEVBQUUsR0FBRyxDQUFFLENBQUM7WUFDcEYsSUFBRyxXQUFXLEVBQUM7Z0JBQ1gsSUFBSSxDQUFDLFNBQVMsQ0FBQyxXQUFXLENBQUMsQ0FBQzthQUMvQjtZQUNELE9BQU87U0FDVjtRQUNELDZEQUE2RDtRQUU3RCxJQUFJLE9BQU87WUFBRyxJQUFJLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDM0IsSUFBSSxDQUFDLFlBQVksQ0FBRSxHQUFHLEVBQUUsV0FBVyxFQUFFLGNBQWMsRUFBRSxPQUFPLEVBQUUsTUFBTSxDQUFFLENBQUM7SUFDM0UsQ0FBQztJQWtCRCw0QkFBUyxHQUFULFVBQVUsV0FBbUI7UUFDekIsSUFBSSxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBQ2hCLElBQUcsV0FBVyxFQUFDO1lBQ1gsRUFBRSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FBQyxXQUFXLEVBQUUsVUFBQyxHQUFHLEVBQUUsRUFBaUI7Z0JBQ2xFLElBQUcsQ0FBQyxHQUFHLElBQUksRUFBRSxFQUFDO29CQUNWLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztvQkFDZCxJQUFJLENBQUMsV0FBVyxHQUFHLEVBQUUsQ0FBQztvQkFDdEIsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO29CQUNkLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztpQkFDcEI7WUFDTCxDQUFDLENBQUMsQ0FBQztTQUNOO0lBQ0wsQ0FBQztJQUVEOzs7Ozs7O09BT0c7SUFDSCw4QkFBVyxHQUFYLFVBQWEsR0FBWSxFQUFFLFdBQXFCLEVBQUUsY0FBeUIsRUFBRSxPQUFrQixFQUFFLE1BQXdDO1FBQ3JJLElBQUcsQ0FBQyxHQUFHLEVBQUM7WUFDSixJQUFJLENBQUMsU0FBUyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1lBQzVCLE9BQU87U0FDVjtRQUNELElBQUksSUFBSSxHQUFHLElBQUksQ0FBQztRQUNoQixJQUFJLEdBQUcsR0FBRyxFQUFFLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztRQUM3QyxJQUFHLENBQUMsR0FBRyxDQUFDLE1BQU0sRUFBQztZQUNYLEdBQUcsR0FBRyxNQUFNLENBQUM7U0FDaEI7UUFDRCxFQUFFLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBRSxHQUFHLEVBQUUsRUFBQyxHQUFHLEtBQUEsRUFBQyxFQUFFLFVBQUUsR0FBRyxFQUFFLE9BQW9CO1lBQy9ELFNBQVM7WUFDVCxJQUFJLENBQUMsSUFBSSxJQUFJLENBQUMsRUFBRSxDQUFDLE9BQU8sQ0FBRSxJQUFJLENBQUUsRUFBRztnQkFDL0IsRUFBRSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEVBQUUsNENBQTRDLENBQUUsQ0FBQztnQkFDM0QsT0FBTzthQUNWO1lBRUQsSUFBRyxHQUFHLEVBQUM7Z0JBQ0gsRUFBRSxDQUFDLEdBQUcsQ0FBQyxHQUFHLEVBQUUsZ0NBQWdDLEdBQUcsR0FBRyxDQUFDLENBQUM7Z0JBQ3BELElBQUksQ0FBQyxTQUFTLENBQUMsV0FBVyxDQUFDLENBQUM7Z0JBQzVCLE9BQU87YUFDVjtZQUVELE9BQU8sQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUVqQixJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDZCxJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksRUFBRSxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUMvQyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDZCxPQUFPLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztZQUN6QixrQ0FBa0M7WUFDbEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxDQUFDLENBQUM7WUFDeEIsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ2pCLE1BQU0sSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ3ZDLENBQUMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztJQUVELDRCQUFTLEdBQVQ7UUFDSSxhQUFhO1FBQ2IsSUFBSSxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssSUFBSSxDQUFDLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLElBQUksQ0FBQyxFQUFHO1lBQ2hELFdBQVc7WUFDWCxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxDQUFDLEtBQUssQ0FBQztZQUNuRCxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxDQUFDLE1BQU0sQ0FBQztTQUN4RDthQUFNO1lBQ0gsY0FBYztZQUNkLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ2xDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO1NBQ3ZDO0lBQ0wsQ0FBQztJQUVELDBCQUFPLEdBQVAsVUFBUSxJQUFjO1FBQ2xCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBQ2pCLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQztJQUNyQixDQUFDO0lBbEtEO1FBREMsUUFBUSxFQUFFO3lDQUNPO0lBSWxCO1FBREMsUUFBUSxDQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUU7MENBQ2lCO0lBUHBCLFFBQVE7UUFENUIsT0FBTztPQUNhLFFBQVEsQ0F1SzVCO0lBQUQsZUFBQztDQXZLRCxBQXVLQyxDQXZLcUMsRUFBRSxDQUFDLE1BQU0sR0F1SzlDO2tCQXZLb0IsUUFBUSIsImZpbGUiOiIiLCJzb3VyY2VSb290IjoiLyIsInNvdXJjZXNDb250ZW50IjpbIlxubGV0IFRBRyA9IFwiTmV0RnJhbWVcIjtcbmNvbnN0IHsgY2NjbGFzcywgcHJvcGVydHkgfSA9IGNjLl9kZWNvcmF0b3I7XG5cbi8vIE9iamVjdC52YWx1ZXMoY2MuYXNzZXRNYW5hZ2VyLmFzc2V0cy5fbWFwKS5maWx0ZXIoKGEpPT4hYS5uYW1lLmluY2x1ZGVzKFwiYnVpbHRpbi1cIikpXG5AY2NjbGFzc1xuZXhwb3J0IGRlZmF1bHQgY2xhc3MgTmV0RnJhbWUgZXh0ZW5kcyBjYy5TcHJpdGUge1xuICAgIC8vIOe9kee7nOWbvueJh+WcsOWdgFxuICAgIEBwcm9wZXJ0eSgpXG4gICAgdXJsIDogc3RyaW5nID0gXCJcIjtcbiBcbiAgICAvLyDmmL7npLrnmoRzcHJpdGXlpKflsI9cbiAgICBAcHJvcGVydHkoIGNjLnNpemUgKVxuICAgIHNpemUgOiBjYy5TaXplID0gbmV3IGNjLlNpemUoIDAsIDAgKTtcbiBcbiAgICAvLyDpu5jorqTlm77niYdcbiAgICBwcml2YXRlIHNwRnJhbWVfIDogY2MuU3ByaXRlRnJhbWUgPSBudWxsO1xuIFxuICAgIC8vIOWbvueJh+exu+WeiyAwOiDpu5jorqTlm77vvJsgMTrliqDovb3lm75cbiAgICBwcml2YXRlIGlzU3BGcmFtZVR5cGVfIDogbnVtYmVyID0gMDtcbiBcbiAgICBvbkxvYWQoKSB7Ly8g57uE5bu65bey57uP5Yib5bu65LqG77yM5L2G5piv5Y+I5omn6KGM5LqGYWN0aXZlLCDkvJrlm57osINvbkxvYWRcbiAgICAgICAgdGhpcy5zcEZyYW1lXyA9IHRoaXMuc3ByaXRlRnJhbWU7XG4gICAgICAgIC8vIHRoaXMuYWRkUmVmKCk7XG4gICAgfVxuIFxuICAgIG9uRGVzdHJveSgpe1xuICAgICAgICB0aGlzLmRlY1JlZigpO1xuICAgIH1cbiAgICBcbiAgICBzdGFydCgpIHtcbiAgICAgICAgLy8gY29uc29sZS5sb2coJ3N0YXJ0IHVybDonLCB0aGlzLnVybCk7XG4gICAgICAgIC8vIHRoaXMubG9hZEZyYW1lKCB0aGlzLnVybCApO1xuICAgIH1cbiBcbiAgICBkZWNSZWYoKXtcbiAgICAgICAgY2MuaXNWYWxpZCh0aGlzLnNwcml0ZUZyYW1lKSAmJiB0aGlzLnNwcml0ZUZyYW1lLmRlY1JlZigpO1xuICAgIH1cbiBcbiAgICBhZGRSZWYoKXtcbiAgICAgICAgY2MuaXNWYWxpZCh0aGlzLnNwcml0ZUZyYW1lKSAmJiB0aGlzLnNwcml0ZUZyYW1lLmFkZFJlZigpO1xuICAgIH1cbiBcbiAgICAvKipcbiAgICAgKiDph43nva7miJDljp/lm77vvIzmlrnkvr/ph43lpI3kvb/nlKhcbiAgICAgKi9cbiAgICByZXNldCgpIHtcbiAgICAgICAgLy8gcmV0dXJuO1xuICAgICAgICAvLyDliKDpmaTkuIrmrKHliJvlu7rnmoRzZlxuICAgICAgICAvLyBpZiggdGhpcy5pc1NwRnJhbWVUeXBlXyAhPSAwICYmIHRoaXMuc3ByaXRlRnJhbWUgJiYgY2MuaXNWYWxpZCggdGhpcy5zcHJpdGVGcmFtZSApICkge1xuICAgICAgICAvLyAgICAgdGhpcy5zcHJpdGVGcmFtZS5kZWNSZWYoKTtcbiAgICAgICAgLy8gICAgIHRoaXMuc3ByaXRlRnJhbWUgPSBudWxsO1xuICAgICAgICAvLyB9XG4gICAgICAgIHRoaXMuZGVjUmVmKCk7XG4gXG4gICAgICAgIC8vIOi/mOWOn+m7mOiupOWbvlxuICAgICAgICB0aGlzLmlzU3BGcmFtZVR5cGVfID0gMDtcbiAgICAgICAgdGhpcy5zcHJpdGVGcmFtZSA9IHRoaXMuc3BGcmFtZV87XG4gICAgICAgIHRoaXMuYWRkUmVmKCk7XG4gICAgfVxuIFxuICAgIC8qKlxuICAgICAqIOWKoOi9vee9kee7nOWbvlxuICAgICAqIEBwYXJhbSB1cmwg572R57uc5Zu+5Zyw5Z2AIFxuICAgICAqIEBwYXJhbSBpc1VzZVdlYk9uTG9hZCDliKTmlq3ljp/nlJ/lubPlj7DmmK/lkKbkvb/nlKh3ZWLkuIvovb1cbiAgICAgKi9cbiAgICBsb2FkRnJhbWUoIHVybCA6IHN0cmluZywgZGVmYXVsdFBhdGggPzogc3RyaW5nLCBpc1VzZVdlYk9uTG9hZCA/OiBib29sZWFuLCBpc1Jlc2V0ID86IGJvb2xlYW4sIG9uU3VjYyA/OiAoc3BlIDogY2MuU3ByaXRlRnJhbWUpID0+IHZvaWQgKSB7XG4gICAgICAgIGlmKCAhdXJsICkge1xuICAgICAgICAgICAgLy8gY2MubG9nKFRBRywgXCIgbG9hZEZyYW1lIGxvYWQgZXJyIHVybCBpcyBudWxsIC4uLiBcIik7XG4gICAgICAgICAgICBpZiggaXNVc2VXZWJPbkxvYWQgKSBjYy5sb2coVEFHLCBcIiBsb2FkRnJhbWUgbG9hZCB1cmwgZXJyIHVybCA9IDIyMjIyMjIyMjIgXCIsIHVybCApO1xuICAgICAgICAgICAgaWYoZGVmYXVsdFBhdGgpe1xuICAgICAgICAgICAgICAgIHRoaXMubG9hZExvY2FsKGRlZmF1bHRQYXRoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICAvLyBjYy5sb2coVEFHLCBcIiBsb2FkRnJhbWUgbG9hZCAgLi4uIFwiICsgdXJsICsgXCIgXCIgKyBpc2l0ZW0pO1xuIFxuICAgICAgICBpZiggaXNSZXNldCApIHRoaXMucmVzZXQoKTtcbiAgICAgICAgdGhpcy5sb2FkRnJhbWVQbmcoIHVybCwgZGVmYXVsdFBhdGgsIGlzVXNlV2ViT25Mb2FkLCBpc1Jlc2V0LCBvblN1Y2MgKTtcbiAgICB9XG4gXG4gICAgLyoqXG4gICAgICog6Zmk5LqGZmFjZWJvb2vvvIzmraPluLjnmoTpg73otbDov5nkuKrpgLvovpFcbiAgICAgKiBAcGFyYW0gdXJsIFxuICAgICAqIEBwYXJhbSBkZWZhdWx0UGF0aCBcbiAgICAgKiBAcGFyYW0gaXNVc2VXZWJPbkxvYWQgXG4gICAgICogQHBhcmFtIGlzUmVzZXQgXG4gICAgICogQHBhcmFtIG9uU3VjYyBcbiAgICAgKi9cbiAgICBsb2FkRnJhbWVQbmcgPSB0aGlzLmxvYWRIZWFkVXJsLmJpbmQoIHRoaXMgKTtcbiBcbiAgICAvKipcbiAgICAgKiDpkojlr7lGYWNlYm9va+ayoeaciS5wbmfnrYnlkI7nvIDnmoTlm77niYflnLDlnYBcbiAgICAgKiBAcGFyYW0gdXJsIFxuICAgICAqL1xuICAgIGxvYWRGcmFtZU5vUG5nID0gdGhpcy5sb2FkSGVhZFVybC5iaW5kKCB0aGlzICk7XG4gXG4gICAgbG9hZExvY2FsKGRlZmF1bHRQYXRoOiBzdHJpbmcpe1xuICAgICAgICBsZXQgc2VsZiA9IHRoaXM7XG4gICAgICAgIGlmKGRlZmF1bHRQYXRoKXtcbiAgICAgICAgICAgIGNjLnJlc291cmNlcy5sb2FkKGRlZmF1bHRQYXRoLCBjYy5TcHJpdGVGcmFtZSwgKGVyciwgc3A6Y2MuU3ByaXRlRnJhbWUpID0+IHtcbiAgICAgICAgICAgICAgICBpZighZXJyICYmIHNwKXtcbiAgICAgICAgICAgICAgICAgICAgc2VsZi5kZWNSZWYoKTtcbiAgICAgICAgICAgICAgICAgICAgc2VsZi5zcHJpdGVGcmFtZSA9IHNwO1xuICAgICAgICAgICAgICAgICAgICBzZWxmLmFkZFJlZigpO1xuICAgICAgICAgICAgICAgICAgICBzZWxmLnJlc2V0U2l6ZSgpO1xuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgIH0pO1xuICAgICAgICB9XG4gICAgfVxuIFxuICAgIC8qKlxuICAgICAqIOWchuW9ouWktOWDj+S9v+eUqFxuICAgICAqIEBwYXJhbSB1cmwgXG4gICAgICogQHBhcmFtIGRlZmF1bHRQYXRoIFxuICAgICAqIEBwYXJhbSBpc1VzZVdlYk9uTG9hZCBcbiAgICAgKiBAcGFyYW0gaXNSZXNldCBcbiAgICAgKiBAcGFyYW0gb25TdWNjIFxuICAgICAqL1xuICAgIGxvYWRIZWFkVXJsKCB1cmwgOiBzdHJpbmcsIGRlZmF1bHRQYXRoID86IHN0cmluZywgaXNVc2VXZWJPbkxvYWQgPzogYm9vbGVhbiwgaXNSZXNldCA/OiBib29sZWFuLCBvblN1Y2MgPzogKHNwZSA6IGNjLlNwcml0ZUZyYW1lKSA9PiB2b2lkICkge1xuICAgICAgICBpZighdXJsKXtcbiAgICAgICAgICAgIHRoaXMubG9hZExvY2FsKGRlZmF1bHRQYXRoKTtcbiAgICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICBsZXQgc2VsZiA9IHRoaXM7XG4gICAgICAgIGxldCBleHQgPSBjYy5wYXRoLmV4dG5hbWUodXJsKS50b0xvd2VyQ2FzZSgpO1xuICAgICAgICBpZighZXh0Lmxlbmd0aCl7XG4gICAgICAgICAgICBleHQgPSAnLnBuZyc7XG4gICAgICAgIH1cbiAgICAgICAgY2MuYXNzZXRNYW5hZ2VyLmxvYWRSZW1vdGUoIHVybCwge2V4dH0sICggZXJyLCB0ZXh0dXJlOmNjLlRleHR1cmUyRCkgPT4ge1xuICAgICAgICAgICAgLy8g5Y+v6IO95bey57uP6ZSA5q+BXG4gICAgICAgICAgICBpZiggIXNlbGYgfHwgIWNjLmlzVmFsaWQoIHNlbGYgKSApIHtcbiAgICAgICAgICAgICAgICBjYy5sb2coVEFHLCBcIiBsb2FkRnJhbWUgbG9hZCB1cmwgZXJyIHVybCA9IDMzMzMzMzMzMzMzIFwiICk7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuIFxuICAgICAgICAgICAgaWYoZXJyKXtcbiAgICAgICAgICAgICAgICBjYy5sb2coVEFHLCBcIiBsb2FkRnJhbWUgbG9hZCB1cmwgZXJyIHVybCA9IFwiICsgdXJsKTtcbiAgICAgICAgICAgICAgICBzZWxmLmxvYWRMb2NhbChkZWZhdWx0UGF0aCk7XG4gICAgICAgICAgICAgICAgcmV0dXJuO1xuICAgICAgICAgICAgfVxuIFxuICAgICAgICAgICAgdGV4dHVyZS5hZGRSZWYoKTtcbiBcbiAgICAgICAgICAgIHNlbGYuZGVjUmVmKCk7XG4gICAgICAgICAgICBzZWxmLnNwcml0ZUZyYW1lID0gbmV3IGNjLlNwcml0ZUZyYW1lKHRleHR1cmUpO1xuICAgICAgICAgICAgc2VsZi5hZGRSZWYoKTtcbiAgICAgICAgICAgIHRleHR1cmUucGFja2FibGUgPSBmYWxzZTtcbiAgICAgICAgICAgIC8vIHNlbGYuc3ByaXRlRnJhbWUgPSBzcHJpdGVGcmFtZTtcbiAgICAgICAgICAgIHNlbGYuaXNTcEZyYW1lVHlwZV8gPSAxO1xuICAgICAgICAgICAgc2VsZi5yZXNldFNpemUoKTtcbiAgICAgICAgICAgIG9uU3VjYyAmJiBvblN1Y2Moc2VsZi5zcHJpdGVGcmFtZSk7XG4gICAgICAgIH0pO1xuICAgIH1cbiBcbiAgICByZXNldFNpemUoKXtcbiAgICAgICAgLy/orr7nva5zcHJpdGXnmoTlpKflsI9cbiAgICAgICAgaWYoIHRoaXMuc2l6ZS53aWR0aCA9PSAwICYmIHRoaXMuc2l6ZS5oZWlnaHQgPT0gMCApIHtcbiAgICAgICAgICAgIC8vIOaMieeFp+WOn+WbvuWkp+Wwj+aYvuekulxuICAgICAgICAgICAgdGhpcy5ub2RlLndpZHRoID0gdGhpcy5zcHJpdGVGcmFtZS5nZXRSZWN0KCkud2lkdGg7XG4gICAgICAgICAgICB0aGlzLm5vZGUuaGVpZ2h0ID0gdGhpcy5zcHJpdGVGcmFtZS5nZXRSZWN0KCkuaGVpZ2h0O1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgLy8g5oyJ54Wn6K6+572u55qE5aSn5bCP5pi+56S65Zu+54mHXG4gICAgICAgICAgICB0aGlzLm5vZGUud2lkdGggPSB0aGlzLnNpemUud2lkdGg7XG4gICAgICAgICAgICB0aGlzLm5vZGUuaGVpZ2h0ID0gdGhpcy5zaXplLmhlaWdodDtcbiAgICAgICAgfVxuICAgIH1cbiBcbiAgICBzZXRTaXplKHNpemUgOiBjYy5TaXplKXtcbiAgICAgICAgdGhpcy5zaXplID0gc2l6ZTtcbiAgICAgICAgdGhpcy5yZXNldFNpemUoKTtcbiAgICB9XG4gXG59XG4iXX0=