import { _decorator, Component, Label, log, native, Node, NodeEventType } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('testDownload')
export class testDownload extends Component 
{

    private str : Label = null
    start() 
    {
        this.str = this.node.getChildByName("str").getComponent(Label)
        const btn = this.node.getChildByName("btn")
        btn.on( NodeEventType.TOUCH_END , ()=>
        {
            // native.Downloader
            this.onDownload()
        } )

    }

    private onDownload()
    {
        const hints: native.DownloaderHints = { // create a DownloaderHints interface
             countOfMaxProcessingTasks: 6,
             timeoutInSeconds: 0,
             tempFileNameSuffix: ".tmp"
        };
        const d = new native.Downloader(hints)
        d.onError = (task: native.DownloadTask, errorCode: number, errorCodeInternal: number, errorStr: string)=>
        {
            log("下载错误")
        }
        d.onProgress = (task: native.DownloadTask, bytesReceived: number, totalBytesReceived: number, totalBytesExpected: number)=>
        {
            const p = bytesReceived / totalBytesReceived
            this.str.string = p.toString();
        }
        d.onSuccess = (task: native.DownloadTask)=>
        {
            log("下载成功")
        }
        const path = native.fileUtils.getWritablePath();
        log( "下载地址"  + path);
        const file = "https://download.cocos.org/CocosCreator/v3.8.4/CocosCreator-v3.8.4-win-093010.zip"
        log( "下载链接"  + file);
        d.createDownloadTask(file, path);
    }

}


