
import { _decorator, Component, Node, instantiate, find, Layers, Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Typescript')
export class Typescript extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    @property(Node)
    testButton:Node |null = null;
    @property(Node)
    testEdit:Node |null = null;
    start () {
        // [3]

        this.scheduleOnce(()=>{
            let item1 = instantiate(this.testButton as Node);
            find('Canvas/Mask-003')?.addChild(item1);
            item1.position.x = 0;
            item1.layer = Layers.Enum.UI_2D;

            let item2 = instantiate(this.testEdit as Node);
            find('Canvas/Mask-001')?.addChild(item2);
            item2.position.x = 0;
            item2.layer = Layers.Enum.UI_2D;
        },3)
    }

    activeChange(){
        let mask = find('Canvas/Mask');
        let mask1 = find('Canvas/Mask-001');
        let mask2 = find('Canvas/Mask-002');
        let mask3 = find('Canvas/Mask-003');
        mask!.active = !mask?.active;
        mask1!.active = !mask1?.active;
        mask2!.active = !mask2?.active;
        mask3!.active = !mask3?.active;

    }
    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
