const { ccclass, property, inspector, menu } = cc._decorator;

@ccclass
@menu('Blade/EditorButton')
@inspector('packages://editor-button/inspector/ediotor_button.js')
export default class EditorButton extends cc.Component {

    @property({ displayName: '通知消息' })
    msg = '';
    @property({ displayName: '参数' })
    param = '';
    @property({ displayName: '设置按钮名称' })
    inputBtnName = '';
    @property({ displayName: '最终按钮名称' })
    _finalBtnName = '';
    @property({ displayName: '当前按钮名称' })
    _curBtnName = '设置按钮名称'



    onBtnClicked() {
        if (this._finalBtnName.length == 0) {
            this._finalBtnName = this.inputBtnName;
        }
        else {
            if (this.msg.length > 0) {
                /**@界面监听消息即可 */
                Editor.log(`发送通知消息，执行逻辑`)
                cc.director.emit('refresh_label', this.param);
            }
            else {
                CC_EDITOR && Editor.warn(`请输入通知消息!`);
            }
        }
    }
}
