"use strict";
Vue.component('editor-button', {
    // 修改组件在 inspector 的显示样式
    template: `
    <ui-prop
        v-prop="target.msg"
        :multi-values="multi"
        v-show="isMsgShow()"
    ></ui-prop>

    <ui-prop
        v-prop="target.param"
        multiline
        :multi-values="multi"
        v-show="isMsgShow()"
    ></ui-prop>

    <ui-prop
        v-prop="target.inputBtnName"
        :multi-values="multi"
        v-show="isInputPropShow()"
    ></ui-prop>

    <div class="horizontal layout end-justified" style="padding:5px 0;margin-bottom:5px;">
        <ui-button class="blue tiny" @confirm="onBtnClicked">
        {{getCurrentBtnName()}}  
        </ui-button>
    </div>
  `,

    props: {
        target: {
            twoWay: true,
            type: Object,
        }, multi: { type: Boolean }
    },
    methods: {
        T: Editor.T,
        onBtnClicked() {
            let o = cc.engine.getInstanceById(this.target.uuid.value);
            o.onBtnClicked();
        },
        isInputPropShow() {
            return this.target._finalBtnName.value.length == 0;
        },
        isMsgShow() {
            return !this.isInputPropShow();
        },
        getCurrentBtnName() {
            if (this.target._finalBtnName.value.length == 0) {
                return "初始化按钮名称";
            }
            else {
                return this.target._finalBtnName.value;
            }
        }
    }

});