const ObjectData = require('./object-data');
const { addPropHierarchyChildItem } = require('./util');


const __prefab = '__prefab';

class ComponentData extends ObjectData {
    get isPrefab() {
        return this.jsonData[__prefab] !== undefined && this.jsonData[__prefab] != null;
    }

    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        addPropHierarchyChildItem(item, this, __prefab);

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        this.mergePropContainedIndices(containedIndices, __prefab);

        return containedIndices;
    }
}

module.exports = ComponentData;
