const ComponentData = require("./component-data");
const { addPropHierarchyChildItem } = require("./util");

const ligthmapSettingsKey = 'lightmapSettings';

class MeshRendererData extends ComponentData {
    
    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        addPropHierarchyChildItem(item, this, ligthmapSettingsKey);

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        this.mergePropContainedIndices(containedIndices, ligthmapSettingsKey);

        return containedIndices;
    }
}

module.exports = MeshRendererData;