const ObjectData = require('./object-data');
const ArrayData = require('./array-data');
const { idPropKey } = require('./defines');
const { getPropInspectorItemData, getPropHierarchyItemData } = require('./util');

const prefabKey = '_prefab';
const componentsKey = '_components';
class NodeData extends ObjectData {

    get name() {
        return super.name + `(${this.type})`;
    }

    get children() {
        let childrenData = [];
        if (this.jsonData._children) {
            this.jsonData._children.forEach((child, index) => {
                if (!child) {
                    return;
                }

                const childSourceIndex = child[idPropKey];
                let childData = this.sceneDataList[childSourceIndex];
                childrenData.push(childData);
            });
        }
        return childrenData;
    }

    get components() {
        let componentsData = [];
        if (this.jsonData._components) {
            this.jsonData._components.forEach((comp, index) => { 
                if (!comp) {
                    return;
                }
                const compSourceIndex = comp[idPropKey];              
                let compData = this.sceneDataList[compSourceIndex];
                componentsData.push(compData);
            });
        }

        return componentsData;
    }

    get isPrefab() {
        return this.jsonData._prefab !== undefined && this.jsonData._prefab != null;
    }

    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        if (this.children && this.children.length > 0) {
            let children = this.children.map((child) => {
                return child.getHierarchyTreeItemData()
            });

            if (!item.children) {
                item.children = [];
            }

            item.children.push(...children);
        }


        return item;
    }

    getComponentsTreeItemData() {
        let item = null;
        if (this.components && this.components.length > 0) {
            
            const compsArray = new ArrayData(this.jsonData._components, this.sceneDataList, 'components');
            item = compsArray.getHierarchyTreeItemData();

            let compsData = []
            this.components.forEach((comp, index) => {   
                let compItem = comp.getHierarchyTreeItemData();
                compsData.push(compItem);
            });
            item.children = compsData;
        }

        return item;
    }

    getInspectorTreeItemData() {
        let inspectorItems = [];
        const compItems = getPropHierarchyItemData(this, componentsKey);
        if (compItems) {
            inspectorItems.push(compItems);
        }

        const prefabItems = getPropHierarchyItemData(this, prefabKey);
        if (prefabItems) {
            inspectorItems.push(prefabItems);
        }

        return inspectorItems;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();
        if (this.children && this.children.length > 0) {
            this.children.forEach((child) => {
                this.mergeContainedIndices(containedIndices, child);
            });
        }

        if (this.components && this.components.length > 0) {
            this.components.forEach((comp) => {   
                this.mergeContainedIndices(containedIndices, comp);
            });
        }

        this.mergePropContainedIndices(containedIndices, '_prefab');

        return containedIndices;
    }

    onRemoved(sceneDataMgr) {
        
    }
}

module.exports = NodeData;
