
const ObjectData = require('./object-data');
const NodeData = require('./node-data');
const ComponentData = require('./component-data');
const PrefabInfoData = require('./prefab/prefab-info-data');
const PrefabInstanceData = require('./prefab/prefab-instance-data');
const PropertyOverrideInfoData = require('./prefab/property-override-info-data');
const MeshRendererData = require('./mesh-renderer-data');
const SceneData = require('./scene-data');
const SceneGlobalsData = require('./scene-globals-data');
const MountedChildrenInfoData = require('./prefab/mounted-children-info-data');
const MountedComponentsInfoData = require('./prefab/mounted-components-info-data');
const TargetOverrideInfoData = require('./prefab/target-override-info-data');

function getDataType(data) {
    return data.__type__;
}

const typeToClassMap = {
    'cc.Node': NodeData,
    'cc.PrefabInfo': PrefabInfoData,
    'cc.PrefabInstance': PrefabInstanceData,
    'CCPropertyOverrideInfo': PropertyOverrideInfoData,
    'cc.MeshRenderer': MeshRendererData,
    'cc.Scene': SceneData,
    'cc.SceneGlobals': SceneGlobalsData,
    'cc.MountedChildrenInfo': MountedChildrenInfoData,
    'cc.MountedComponentsInfo': MountedComponentsInfoData,
    'cc.TargetOverrideInfo': TargetOverrideInfoData
}

class ObjectDataFactory {
    async createObjectData(data, sceneDataList) {
        const type = getDataType(data);
        let objData = null;
        let isComp = await Editor.Message.request('scene', 'execute-scene-script', {
            name: 'scene-file-editor',
            method: 'isComponent',
            args: [
                type
            ],
        });

        if (typeToClassMap.hasOwnProperty(type)) {
            objData = new typeToClassMap[type](data, sceneDataList);
        } else if (isComp) {
            objData = new ComponentData(data, sceneDataList);
        } else {
            objData = new ObjectData(data, sceneDataList);
        }

        return objData;
    }
}

const objectDataFactory = new ObjectDataFactory();

module.exports = objectDataFactory;