const { idPropKey } = require("./defines");

class ObjectData {
    jsonData;   // 原始数据块
    sceneDataList = []; // 整理后的场景数据列表

    constructor(jsonData, sceneDataList) {
        this.jsonData = jsonData;
        this.sceneDataList = sceneDataList;
    }

    get name() {
        return this.jsonData._name || this.type;
    }

    get type() {
        return this.jsonData.__type__;
    }

    get indexOfArray() {
        return this.sceneDataList.indexOf(this);
    }

    get isPrefab() {
        return false;
    }

    getHierarchyTreeItemData() {
        let item = {};
        item.detail = {
            data: this,
            showArrow: false,
        };

        // 会死循环...
        // item.children = [];
        // // 扫出第一层默认有使用id索引的对象
        // Object.keys(this.jsonData).forEach((key) => {
        //     const prop = this.jsonData[key];
        //     if (prop && typeof prop === 'object' && prop.hasOwnProperty(idPropKey)) {
        //         const index = prop[idPropKey];
        //         let propData = this.sceneDataList[index];
        //         item.children.push(propData.getHierarchyTreeItemData());
        //     }
        // });

        return item;
    }

    getInspectorTreeItemData() {
        return null;
    }

    // 所包含的序号，用于只显示树形结构时的剔除
    getContainedIndices() {
        let contains = [this.indexOfArray];
        // // 扫出第一层默认有使用id索引的对象
        // Object.keys(this.jsonData).forEach((key) => {
        //     const prop = this.jsonData[key];
        //     if (typeof prop === 'object' && prop.hasOwnProperty(idPropKey)) {
        //         const index = prop[idPropKey];
        //         let propData = this.sceneDataList[index];
        //         this.mergeContainedIndices(contains, propData);
        //     }
        // });
        return contains;
    }

    mergeContainedIndices(containedIndices, objData) {
        const contains = objData.getContainedIndices();
        containedIndices.push(...contains);
    }

    mergePropContainedIndices(containedIndices, propName) {
        const prop = this.jsonData[propName];
        if (prop) {
            if (Array.isArray(prop)) {
                prop.forEach((elem) => {
                    if (!elem) {
                        console.warn(`null elem in array ${propName}`)
                        return;
                    }
                    const index = elem[idPropKey];
                    const objData = this.sceneDataList[index];

                    if (objData) {
                        this.mergeContainedIndices(containedIndices, objData);
                    }
                });
            } else {
                const index = prop[idPropKey];
                const objData = this.sceneDataList[index];

                if (objData) {
                    this.mergeContainedIndices(containedIndices, objData);
                }
            }
        }
    }

    onRemoved(sceneDataMgr) {

    }
}

module.exports = ObjectData;