const ObjectData = require("../object-data");
const { addPropHierarchyChildItem } = require("../util");

const targetInfoKey = 'targetInfo';
const nodesKey = 'nodes';
class MountedChildrenInfoData extends ObjectData {
    get name() {
        return this.type;
    }

    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        addPropHierarchyChildItem(item, this, targetInfoKey);
        addPropHierarchyChildItem(item, this, nodesKey);

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        this.mergePropContainedIndices(containedIndices, targetInfoKey);
        this.mergePropContainedIndices(containedIndices, nodesKey);

        return containedIndices;
    }
}

module.exports = MountedChildrenInfoData;
