const ObjectData = require("../object-data");
const { addPropHierarchyChildItem } = require("../util");

const targetInfoKey = 'targetInfo';
const componentsKey = 'components';
class MountedComponentsInfoData extends ObjectData {
    get name() {
        return this.type;
    }

    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        addPropHierarchyChildItem(item, this, targetInfoKey);
        addPropHierarchyChildItem(item, this, componentsKey);

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        this.mergePropContainedIndices(containedIndices, targetInfoKey);
        this.mergePropContainedIndices(containedIndices, componentsKey);

        return containedIndices;
    }
}

module.exports = MountedComponentsInfoData;
