const ObjectData = require('../object-data');
const { addPropHierarchyChildItem } = require('../util');

const instanceKey = 'instance';
const targetOverridesKey = 'targetOverrides';
class PrefabInfoData extends ObjectData {
    get name() {
        return this.type;
    }

    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        addPropHierarchyChildItem(item, this, instanceKey);
        addPropHierarchyChildItem(item, this, targetOverridesKey);

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        this.mergePropContainedIndices(containedIndices, instanceKey);
        this.mergePropContainedIndices(containedIndices, targetOverridesKey);

        return containedIndices;
    }
}

module.exports = PrefabInfoData;