const ObjectData = require('../object-data');

const { addPropHierarchyChildItem } = require('../util');

const props = [
    'propertyOverrides',
    'mountedChildren',
    'mountedComponents',
    'removedComponents'
];

class PrefabInstanceData extends ObjectData {
    get name() {
        return this.type;
    }

    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        props.forEach((propName) => {
            addPropHierarchyChildItem(item, this, propName);
        });

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        props.forEach((propName) => {
            this.mergePropContainedIndices(containedIndices, propName);
        });

        return containedIndices;
    }
}

module.exports = PrefabInstanceData;