const ObjectData = require('../object-data');
const { addPropHierarchyChildItem } = require('../util');

const targetInfoKey = 'targetInfo';
class PropertyOverrideInfoData extends ObjectData {
    get name() {
        return this.type;
    }

    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        addPropHierarchyChildItem(item, this, targetInfoKey);

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        this.mergePropContainedIndices(containedIndices, targetInfoKey);

        return containedIndices;
    }
}

module.exports = PropertyOverrideInfoData;