const ObjectData = require("../object-data");
const { addPropHierarchyChildItem } = require("../util");

const sourceKey = 'source';
const sourceInfoKey = 'sourceInfo';
const targetKey = 'target';
const targetInfoKey = 'targetInfo';
class TargetOverrideInfoData extends ObjectData {
    get name() {
        return this.type;
    }

    getHierarchyTreeItemData() {
        let item = super.getHierarchyTreeItemData();

        addPropHierarchyChildItem(item, this, sourceKey);
        addPropHierarchyChildItem(item, this, sourceInfoKey);
        addPropHierarchyChildItem(item, this, targetKey);
        addPropHierarchyChildItem(item, this, targetInfoKey);

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        this.mergePropContainedIndices(containedIndices, sourceKey);
        this.mergePropContainedIndices(containedIndices, sourceInfoKey);
        this.mergePropContainedIndices(containedIndices, targetKey);
        this.mergePropContainedIndices(containedIndices, targetInfoKey);

        return containedIndices;
    }
}

module.exports = TargetOverrideInfoData;
