const objectDataFactory = require('./object-data-factory');
const sceneDataProxy = require('./scene-data-proxy');


// 将原始场景的json数据整理成更方便使用的数据类型
class SceneDataManager {
    sceneJsonData = null;

    sceneDataList = [];
    async parseJson(sceneJsonData) {
        this.sceneJsonData = sceneJsonData;

        if (!Array.isArray(sceneJsonData)) {
            console.warn('scene data is not an array');
            return;
        }

        this.sceneDataList = [];
        for (let i = 0; i < sceneJsonData.length; i++) {
            const data = sceneJsonData[i];
            const objData = await objectDataFactory.createObjectData(data, this.sceneDataList);
            this.sceneDataList[i] = objData;
        }

        sceneDataProxy.parseJson(sceneJsonData);
    }

    getSceneTree(showAllData = true, filterName) {
        let treeData = [];
        let processedIndices = [];

        let regExp = null
        if (filterName) {
            const pattern = filterName.split('').join('.*?');
            regExp = new RegExp(pattern, 'i');
        }

        this.sceneDataList.forEach((data, index) => {
            if (!showAllData && processedIndices.includes(index)) {
                return;
            }

            const item = data.getHierarchyTreeItemData();

            if (!showAllData) {
                const contains = data.getContainedIndices();
                processedIndices = processedIndices.concat(contains);
            }

            if (!regExp || regExp.test(data.name)) {
                treeData.push(item);
            }
        });

        return treeData;
    }

    removeSceneItem(sceneItemData) {
        let index = this.sceneDataList.indexOf(sceneItemData);
        if (index >= 0) {
            this.sceneDataList.splice(index, 1);
            sceneDataProxy.removeSceneObjectByIndex(index);
            // 各自处理关联的删除
            sceneItemData.onRemoved(this);
        }
    }

}



module.exports = {
    SceneDataManager,
}