
const idPropKey = '__id__';

// 对原始场景的json数据的一个代理，提供一些对原始数据的操作
class SceneDataProxy {
    sceneJsonData = null;
    // 记录__id__所在的Object，用于更新__id__的值
    idObjList = [];

    parseJson(sceneJsonData) {
        this.sceneJsonData = sceneJsonData;
        this.idObjList = this.generateIDObjectList(sceneJsonData);
    }

    checkToAddIDObject(obj, propName, idObjList) {
        if (obj === undefined || obj === null) {
            return;
        }

        const prop = obj[propName];

        if (prop === undefined || prop === null) {
            return;
        }

        if (typeof prop === 'object') {
            Object.keys(prop).forEach((key) => {
                if (key === idPropKey && Number.isInteger(prop[key])) {
                    idObjList.push({
                        obj: prop,
                        owner: obj,
                        propName
                    });
                } else {
                    this.checkToAddIDObject(prop, key, idObjList);
                }
            });
        } else if (Array.isArray(prop)) {
            prop.forEach((elem, index) => {
                this.checkToAddIDObject(prop, index, idObjList);
            });
        }
    }

    generateIDObjectList(jsonData) {
        if (!jsonData) {
            console.error('empty json data');
            return;
        }
        let idObjList = [];

        if (Array.isArray(jsonData)) {
            jsonData.forEach((data, index) => {
                this.checkToAddIDObject(jsonData, index, idObjList);
            })
        } else {
            console.error(`scene data is not an array`);
        }

        return idObjList;
    }

    removeSceneObjectByIndex(index) {
        if (!Array.isArray(this.sceneJsonData)) {
            console.error('scene data is not an array');
            return;
        }

        if (index >= this.sceneJsonData.length) {
            console.error('wrong index:', index);
            return;
        }

        let data = this.sceneJsonData[index];

        this.sceneJsonData.splice(index, 1);

        // 更新__id__
        for (let i = this.idObjList.length - 1; i >= 0; i--) {
            const idObj = this.idObjList[i];
            const obj = idObj.obj;
            const id = obj[idPropKey];
            if (id === index) {
                if (Array.isArray(idObj.owner)) {
                    idObj.owner.splice(idObj.propName, 1);
                } else {
                    if (Array.isArray(data)) {
                        idObj.owner[idObj.propName] = [];
                    } else {
                        idObj.owner[idObj.propName] = null;
                    }
                }
            } else if (id > index) {
                obj[idPropKey] = id - 1;
            }
        }
    }
}

const sceneDataProxy = new SceneDataProxy();

module.exports = sceneDataProxy;