const { idPropKey } = require("./defines");
const NodeData = require("./node-data");
const { getPropInspectorItemData } = require("./util");

const globalsKey = '_globals';

class SceneData extends NodeData {
    getInspectorTreeItemData() {
        let inspectorItems = super.getInspectorTreeItemData();

        let item = getPropInspectorItemData(this, globalsKey);
        if (item) {
            inspectorItems.push(item);
        }

        return inspectorItems;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();
        
        this.mergePropContainedIndices(containedIndices, globalsKey);

        return containedIndices;
    }
}

module.exports = SceneData;
