const ObjectData = require("./object-data");
const { addPropHierarchyChildItem } = require("./util");

const ambientKey = 'ambient';
const shadowsKey = 'shadows';
const skyboxKey = '_skybox';
const fogKey = 'fog';

class SceneGlobalsData extends ObjectData {
    getInspectorTreeItemData() {
        let item = {};
        item.detail = {
            data: this,
            showArrow: false,
        };

        addPropHierarchyChildItem(item, this, ambientKey);
        addPropHierarchyChildItem(item, this, shadowsKey);
        addPropHierarchyChildItem(item, this, skyboxKey);
        addPropHierarchyChildItem(item, this, fogKey);

        return item;
    }

    getContainedIndices() {
        let containedIndices = super.getContainedIndices();

        this.mergePropContainedIndices(containedIndices, ambientKey);
        this.mergePropContainedIndices(containedIndices, shadowsKey);
        this.mergePropContainedIndices(containedIndices, skyboxKey);
        this.mergePropContainedIndices(containedIndices, fogKey);

        return containedIndices;
    }
}

module.exports = SceneGlobalsData;
