const ArrayData = require("./array-data");
const { idPropKey } = require('./defines');

exports.getPropHierarchyItemData = function(objData, propName) {
    let item = null;

    const prop = objData.jsonData[propName];
    if (prop) {
        if (Array.isArray(prop)) {
            if (prop.length <= 0) {
                return;
            }
            
            const propData = new ArrayData(prop, objData.sceneDataList, propName);
            const arrayItem = propData.getHierarchyTreeItemData();

            let arrayData = [];
            prop.forEach((elem) => {
                if (!elem) {
                    console.warn(`null elem in array ${propName}`)
                    return;
                }
                const index = elem[idPropKey];
                const elemData = objData.sceneDataList[index];

                if (elemData) {
                    arrayData.push(elemData.getHierarchyTreeItemData());
                }
            });
            arrayItem.children = arrayData;

            item = arrayItem;
        } else {
            const index = prop[idPropKey];
            const propData = objData.sceneDataList[index];

            if (propData) {
                item = propData.getHierarchyTreeItemData();
            }

        }
    }

    return item;
}

exports.getPropInspectorItemData = function(objData, propName) {
    let item = null;

    const prop = objData.jsonData[propName];
    if (prop) {
        if (Array.isArray(prop)) {
            if (prop.length <= 0) {
                return;
            }
            const propData = new ArrayData(prop, objData.sceneDataList, propName);
            const arrayItem = propData.getInspectorTreeItemData();

            let arrayData = [];
            prop.forEach((elem) => {
                if (!elem) {
                    console.warn(`null elem in array ${propName}`)
                    return;
                }
                const index = elem[idPropKey];
                const elemData = objData.sceneDataList[index];

                if (elemData) {
                    arrayData.push(elemData.getInspectorTreeItemData());
                }
            });
            arrayItem.children = arrayData;

            item = arrayItem;
        } else {
            const index = prop[idPropKey];
            const propData = objData.sceneDataList[index];

            if (propData) {
                item = propData.getInspectorTreeItemData();
            }

        }
    }

    return item;
}

exports.addPropHierarchyChildItem = function (item, objData, propName) {
    let propItem = exports.getPropHierarchyItemData(objData, propName);
    if (propItem) {
        if (!item.children) {
            item.children = [];
        }
        item.children.push(propItem);
    }
}

exports.addPropInspectorChildItem = function (item, objData, propName) {
    let propItem = exports.getPropInspectorItemData(objData, propName);
    if (propItem) {
        if (!item.children) {
            item.children = [];
        }
        item.children.push(propItem);
    }
}

