import { __private, _decorator, Component, Node, UIRenderer } from 'cc';

const { ccclass, property } = _decorator;

/**
 * 渲染分组
 * 适用于子节点结构相同名字相同(不支持子节点中有Mask组件)
 * */
@ccclass('RenderGrouping')
export class RenderGrouping extends Component {
    private _renderComp: UIRenderer = null!;
    private _renderList: string[] = [];
    private _renderGroup: { [groupName: string]: UIRenderer[] } = {};

    protected __preload() {
        this._renderComp = this.getComponent(UIRenderer) ?? this.addComponent(UIRenderer)!;

        (this._renderComp as any).originaFillBuffers = this._renderComp.fillBuffers;
        this._renderComp.fillBuffers = (batcher: __private._cocos_2d_renderer_i_batcher__IBatcher) => {
            (this._renderComp as any).originaFillBuffers.call(this._renderComp, batcher);
            this._renderList.length = 0;
            this._renderGroup = {};
            this.node.children.forEach(child => {
                this.updateRenderGrouping(child, "");
            });
        }

        (this._renderComp as any).originalPostUpdateAssembler = this._renderComp.postUpdateAssembler;
        this._renderComp.postUpdateAssembler = (batcher: __private._cocos_2d_renderer_i_batcher__IBatcher) => {
            (this._renderComp as any).originalPostUpdateAssembler.call(this._renderComp, batcher);
            this._renderList.forEach((name: string) => {
                this._renderGroup[name].forEach(render => {
                    if ((render as any)._renderFlag) {
                        (render as any).originalRender(batcher);
                    }
                });
            });
        }
    }

    // 更新渲染分组
    private updateRenderGrouping(node: Node, groupName: string) {
        if (!node.activeInHierarchy) return;
        groupName = `${groupName}/${node.name.replace(/\d+$/, '')}`;
        let render = node.getComponent(UIRenderer);
        if (render) {
            if (!this._renderGroup[groupName]) {
                this._renderList.push(groupName);
                this._renderGroup[groupName] = [];
            }
            // 架空原始渲染函数
            if ((render as any).originalRender == undefined) {
                (render as any).originalRender = (render as any)._render;
                (render as any)._render = () => {
                };
            }
            this._renderGroup[groupName].push(render);
        }
        node.children.forEach((child: Node) => {
            this.updateRenderGrouping(child, groupName);
        });
        // console.log("组名", this._renderList);
        // console.log("分组", this._renderGroup);
    }
}


