// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    private _spineData: sp.SkeletonData;
    private _effect: cc.EffectAsset;
    //
    private _dbAtlas: dragonBones.DragonBonesAtlasAsset;
    private _dbData: dragonBones.DragonBonesAsset;

    start() {
        // 加载spine
        cc.resources.load('spine/role_4704', sp.SkeletonData, (err, assets: sp.SkeletonData) => {
            this._spineData = assets;
            this.checkAndCreate();
        })
        // 加载龙骨
        // 加载 plist
        cc.resources.load('db/jk_tex', dragonBones.DragonBonesAtlasAsset, (err, dbAtlas: dragonBones.DragonBonesAtlasAsset) => {
            this._dbAtlas = dbAtlas;
            // 加载骨骼
            cc.resources.load('db/jk_ske', dragonBones.DragonBonesAsset, (err, dbData: dragonBones.DragonBonesAsset) => {
                this._dbData = dbData;
                this.checkAndCreate();
            });
        });
        // 加载shader
        cc.resources.load('effect/fighter', cc.EffectAsset, (err, assets: cc.EffectAsset) => {
            this._effect = assets;
            this.checkAndCreate();
        })
    }

    private checkAndCreate() {
        if (!this._spineData || !this._effect || !this._dbAtlas || !this._dbData) {
            return;
        }
        this.createSpine();
        this.createDb();
    }


    private createSpine() {
        // 创建节点
        const modelNode = new cc.Node();
        this.node.addChild(modelNode);
        const ske = modelNode.addComponent(sp.Skeleton);
        // 设置数据
        ske.skeletonData = this._spineData;
        //
        modelNode.y = -250;
        modelNode.x = -245;

        // 创建材质
        const material = cc.Material.create(this._effect);
        material.addRef();
        ske.setMaterial(0, material);
        // 设置参数
        material.setProperty('u_type', 1);
    }

    private createDb() {
        // 创建节点
        const modelNode = new cc.Node();
        this.node.addChild(modelNode);
        // 添加db组件
        const dragonDisplay = this.addComponent(dragonBones.ArmatureDisplay);
        // 设置数据
        dragonDisplay.dragonAtlasAsset = this._dbAtlas;
        dragonDisplay.dragonAsset = this._dbData;
        dragonDisplay.armatureName = 'Armature';

        // 创建材质
        const material = cc.Material.create(this._effect);
        material.addRef();
        dragonDisplay.setMaterial(0, material);
        // 设置参数
        material.setProperty('u_type', 1);
    }
    // update (dt) {}
}
