const { ccclass, property,} = cc._decorator;

@ccclass
export default class SVButton extends cc.Component {
    @property({ type: cc.SpriteFrame, displayName: "分享图标" })
    shareIcon: cc.SpriteFrame = null;

    @property({ type: cc.Sprite, displayName: "图标容器" })
    iconSprite: cc.Sprite = null;

    onEnable() {
        this.node.on("click", this.onClick);
        this.loadSVConfig();
    }

    onDisable() {
        // this.iconSprite.spriteFrame = null;//不报错
        this.iconSprite.spriteFrame = undefined;//报错但2.4.2正常跑
    }

    loadSVConfig(forceShare = false) {
        this.iconSprite.spriteFrame = this.shareIcon;
    }

    onClick = () => {
        
    }
}