// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    // LIFE-CYCLE CALLBACKS:

    @property(cc.Node)
    ad: cc.Node = null;

    @property(cc.Prefab)
    adPF: cc.Prefab = null;
    show: boolean = false;
    adNode: cc.Node;

    // onLoad () {}

    start() {

    }

    isShowPF() {
        if (this.show) {
            this.adNode.active = false;
        } else {
            if (this.adNode) {
                this.adNode.active = true;
            } else {
                this.adNode = cc.instantiate(this.adPF);
                this.adNode.parent = this.ad;
            }
        }
        this.show = !this.show;
    }

    // update (dt) {}
}
