// const fs = require("fs");
// const path = require("path");
// const AdmZip = require("adm-zip");

// // 1. 读取 setting.js
// const settingPath = path.join(__dirname, "src/settings.feb46.js");
// const settingContent = fs.readFileSync(settingPath, "utf-8");

// // 2. 提取 window._CCSettings 对象
// let _CCSettings;
// try {
//     // 用 eval 是因为 setting.js 中是 window._CCSettings=... 的格式
//     const window = {};
//     eval(settingContent); // 执行 setting.js，填充 window._CCSettings
//     _CCSettings = window._CCSettings;
// } catch (e) {
//     console.error("解析 setting.js 失败:", e);
//     process.exit(1);
// }

// if (!_CCSettings || !_CCSettings.bundleVers) {
//     console.error("setting.js 中没有找到 bundleVers 对象");
//     process.exit(1);
// }

// const bundleVers = _CCSettings.bundleVers;

// // 3. 设置要查找的根目录
// const rootDir = path.join(__dirname, "assets"); // 你要搜索的目录

// // 4. 遍历 bundleVers 的 key
// Object.entries(bundleVers).forEach(([key, value]) => {
//     const folderPath = path.join(rootDir, key);

//     if (fs.existsSync(folderPath) && fs.lstatSync(folderPath).isDirectory()) {
//         console.log(`找到文件夹: ${key}, 开始压缩内容...`);

//         // 5. 创建 zip
//         const zip = new AdmZip();

//         // 遍历该文件夹下的所有内容
//         const subItems = fs.readdirSync(folderPath);
//         subItems.forEach(item => {
//             const fullPath = path.join(folderPath, item);
//             // if (fs.lstatSync(fullPath).isDirectory() || fs.lstatSync(fullPath).isFile()) {
//             if (fs.lstatSync(fullPath).isDirectory()) {
//                 zip.addLocalFolder(fullPath, item); // 压缩子目录或文件
//             }
//         });

//         // 6. 生成 zip 文件
//         const zipName = `${key}.${value}.zip`;
//         const outputPath = path.join(folderPath, zipName);
//         zip.writeZip(outputPath);

//         console.log(`压缩完成: ${outputPath}`);
//     } else {
//         console.warn(`未找到文件夹: ${key}`);
//     }
// });

// console.log("全部压缩完成 ✅");



const fs = require("fs");
const path = require("path");
const AdmZip = require("adm-zip");

// 排除一些不需要压缩的分包
const exclude = ["internal", "main", "resources"];

// 1. 通过 index.html 找到 setting 文件名
const indexPath = path.join(__dirname, "build/web-mobile/index.html");
if (!fs.existsSync(indexPath)) {
    console.error("未找到 index.html");
    process.exit(1);
}

const indexContent = fs.readFileSync(indexPath, "utf-8");
const settingMatch = indexContent.match(/src=["']([^"']*setting[^"']*\.js)["']/i);

if (!settingMatch) {
    console.error("index.html 中未找到包含 'src/setting' 的 js 文件路径");
    process.exit(1);
}

console.log("settingMatch[1]====", settingMatch[1])
const settingFileName = path.basename(settingMatch[1]);
const settingPath = path.join(__dirname, `build/web-mobile/${settingMatch[1]}`);

console.log(`找到 setting 文件: ${settingPath}`);

// 2. 读取 setting.js
let _CCSettings;
try {
    const window = {};
    const settingContent = fs.readFileSync(settingPath, "utf-8");
    eval(settingContent); // 执行 setting.js 填充 window._CCSettings
    _CCSettings = window._CCSettings;
} catch (e) {
    console.error("解析 setting.js 失败:", e);
    process.exit(1);
}

if (!_CCSettings || !_CCSettings.bundleVers) {
    console.error("setting.js 中没有找到 bundleVers 对象");
    process.exit(1);
}

const bundleVers = _CCSettings.bundleVers;

// 3. 设置要查找的根目录
const rootDir = path.join(__dirname, "build/web-mobile/assets"); // 修改成你的目录

// 4. 遍历并压缩
Object.entries(bundleVers).forEach(([key, value]) => {
    if (exclude.includes(key)) return;

    const folderPath = path.join(rootDir, key);

    if (fs.existsSync(folderPath) && fs.lstatSync(folderPath).isDirectory()) {
        console.log(`找到文件夹: ${key}, 开始压缩内容...`);

        // 创建 zip
        const zip = new AdmZip();
        const subItems = fs.readdirSync(folderPath);

        subItems.forEach(item => {
            const fullPath = path.join(folderPath, item);
            if (fs.lstatSync(fullPath).isDirectory()) {
                zip.addLocalFolder(fullPath, item);
            }
        });

        // 生成 zip
        const zipName = `${key}.${value}.zip`;
        const outputPath = path.join(folderPath, zipName);
        zip.writeZip(outputPath);
        console.log(`压缩完成: ${outputPath}`);

        // 删除原目录（保留 zip）
        subItems.forEach(item => {
            const targetPath = path.join(folderPath, item);
            if (fs.lstatSync(targetPath).isDirectory()) {
                fs.rmSync(targetPath, { recursive: true, force: true });
                console.log(`已删除目录: ${targetPath}`);
            }
        });
        console.log(`已删除原目录内容: ${folderPath}`);
    } else {
        console.warn(`未找到文件夹: ${key}`);
    }
});

console.log("全部压缩与删除操作完成 ✅");