
import { _decorator, Component, Node, RenderTexture, gfx, Texture2D, Camera, Sprite, SpriteFrame } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Test')
export class Test extends Component
{
    @property(Sprite)
    renderSp:Sprite = null;

    @property(Camera)
    camera:Camera = null;


    start()
    {
        //测试渲染相机看到的内容到RenderTexture上 
        //RenderTexture上的add模式有问题 渲染异常
        this.renderCamera(this.renderSp,this.camera)
    }
    
    renderCamera(icon: Sprite, Camera: Camera)
    {
        let tex = this.createRenderTexture();
        let spriteframe = icon.spriteFrame;
        let renderSp = new SpriteFrame();
        renderSp.reset({
            originalSize: spriteframe.getOriginalSize(),
            rect: spriteframe.getRect(),
            offset: spriteframe.getOffset(),
            isRotate: spriteframe.isRotated(),
            borderTop: spriteframe.insetTop,
            borderLeft: spriteframe.insetLeft,
            borderBottom: spriteframe.insetBottom,
            borderRight: spriteframe.insetRight,
        });
        Camera.targetTexture = tex;
        renderSp.texture = tex;
        icon.spriteFrame = renderSp;
    }

    createRenderTexture(): RenderTexture
    {
        let texture = new RenderTexture();
        let width = 600
        let height = 600

        let colors = [];
        colors.push(new gfx.ColorAttachment(gfx.Format.RGBA8));

        texture.reset({
            width: width, height: height,
            passInfo: new gfx.RenderPassInfo(
                colors, new gfx.DepthStencilAttachment(gfx.Format.DEPTH_STENCIL),
            )
        });

        texture.setFilters(Texture2D.Filter.LINEAR, Texture2D.Filter.LINEAR);
        texture.setWrapMode(Texture2D.WrapMode.CLAMP_TO_BORDER, Texture2D.WrapMode.CLAMP_TO_BORDER);

        return texture;
    }
}
