import {_decorator, Component, EventTouch, Node, Vec2, Vec3} from 'cc';

const {ccclass, property} = _decorator;

/**
 * Predefined variables
 * Name = DragComp
 * DateTime = Wed Mar 30 2022 17:17:19 GMT+0800 (中国标准时间)
 * Author = glp4703
 * FileBasename = DragComp.ts
 * FileBasenameNoExtension = DragComp
 * URL = db://assets/DragComp.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */

let CompId = 1;

export enum Evt {
    Destroy = "Destroy"
}

@ccclass('DragComp')
export class DragComp extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start() {
        // [3]
    }

    // update (deltaTime: number) {
    //     // [4]
    // }
    id: number = 0;
    listened: boolean = false;
    isTouch: boolean = false;
    beginTouchPos: Vec2 = new Vec2();
    nowTouchPos: Vec2 = new Vec2();
    beginPos: Vec3 = new Vec3();

    onLoad() {
        console.log("DragComp onLoad");
        this.id = CompId++;
    }

    protected onEnable(): void {
        console.log("DragComp onEnable");
        this.listenTouch(true);
    }

    protected onDisable(): void {
        console.log("DragComp onDisable");
        this.listenTouch();
    }

    onDestroy() {
        console.log("DragComp onDestroy");
    }

    listenTouch(listen?: boolean) {
        if (listen) {
            if (this.listened) return;
            this.listened = true;
            this.node.on(Node.EventType.TOUCH_START, this.onTouchStart, this, true);
            this.node.on(Node.EventType.TOUCH_CANCEL, this.onTouchCancel, this, true);
            this.node.on(Node.EventType.TOUCH_MOVE, this.onTouchMove, this, true);
            this.node.on(Node.EventType.TOUCH_END, this.onTouchEnd, this, true);
        } else {
            this.listened = false;
            this.node.off(Node.EventType.TOUCH_START, this.onTouchStart, this, true);
            this.node.off(Node.EventType.TOUCH_CANCEL, this.onTouchCancel, this, true);
            this.node.off(Node.EventType.TOUCH_MOVE, this.onTouchMove, this, true);
            this.node.off(Node.EventType.TOUCH_END, this.onTouchEnd, this, true);
        }
    }

    touchFinish() {
        this.isTouch = false;
    }

    onTouchCancel(ev: EventTouch): void {
        console.log("DragComp onTouchCancel this.id=", this.id);
        ev.propagationStopped = true;
        this.touchFinish();
    }

    onTouchEnd(ev: EventTouch): void {
        console.log("DragComp onTouchEnd this.id=", this.id);
        this.touchFinish();
    }

    onTouchMove(ev: EventTouch): void {
        console.log("DragComp onTouchMove");
        if (!this.isTouch) return;
        ev.getLocation(this.nowTouchPos);

        let diff = this.nowTouchPos.clone().subtract(this.beginTouchPos);
        // console.log("diff=", diff);
        this.node.position = this.beginPos.clone().add3f(diff.x, diff.y, 0);

        console.log("this.node.position.x=", this.node.position.x);
        if (this.node.position.x > 240) {
            // game.emit(Evt.Destroy, this);
            console.log("emit");
            this.node.parent!.emit(Evt.Destroy, this);
        }
    }

    onTouchStart(ev: EventTouch): void {
        console.log("DragComp onTouchStart  this.id=", this.id);

        this.isTouch = true;
        ev.getLocation(this.beginTouchPos);
        this.node.getPosition(this.beginPos);
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
