import {_decorator, Component, instantiate, Node, Prefab, v3} from 'cc';
import {DragComp, Evt} from "db://assets/DragComp";

const {ccclass, property} = _decorator;

/**
 * Predefined variables
 * Name = Main
 * DateTime = Wed Mar 30 2022 17:24:50 GMT+0800 (中国标准时间)
 * Author = glp4703
 * FileBasename = Main.ts
 * FileBasenameNoExtension = Main
 * URL = db://assets/Main.ts
 * ManualUrl = https://docs.cocos.com/creator/3.4/manual/zh/
 *
 */

@ccclass('Main')
export class Main extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;
    @property(Prefab)
    prefab: Prefab = null!;

    pools: Node[] = [];

    start() {
        // [3]
        const that = this;
        this.node.on(Evt.Destroy, function (cp: DragComp) {
            console.log("node destroy");
            cp.node.parent = null;
            that.pools.push(cp.node);
        })
    }

    // update (deltaTime: number) {
    //     // [4]
    // }

    addPrefab() {
        let node = this.pools.pop()
        if (!node) {
            node = instantiate(this.prefab);
        }
        node.parent = this.node;
        node.position = v3(0, 0, 0);
    }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.4/manual/zh/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.4/manual/zh/scripting/decorator.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.4/manual/zh/scripting/life-cycle-callbacks.html
 */
