
const ChainParams = {
    ChainId : 97,
    ChainName:"BSC Test",
    RpcUrl :"https://data-seed-prebsc-1-s3.binance.org:8545/",
    ExplorerUrl:"https://testnet.bscscan.com/",

    Token_USDTAddress : "0xeD24FC36d5Ee211Ea25A80239Fb8C4Cfd80f12Ee"
}

export var EthersUtils = {
    provider : null,
    signer : null,
    address: "",
    ethereum : null,
    ChainParams:ChainParams,
    async connectWallet(){
        var ethereum = window['ethereum']
        if (!ethereum) {
            console.log("未安装好metamask?")
            return null
        }
        await ethereum.enable()
        this.ethereum = ethereum;
        this.provider = new ethers.providers.Web3Provider(ethereum);
        this.signer = await this.provider && this.provider.getSigner();
        const { chainId } = await this.provider.getNetwork()
        if(parseInt(chainId) != ChainParams.ChainId){
            console.log("链不对")
            this.switchChainId()
            return null;
        } else {
            this.address = await this.signer.getAddress();
            console.log("链接成功:address:",this.address)
            return this.address
        }
    },
    switchChainId(){
        this.ethereum &&this.ethereum.request({
            method: 'wallet_addEthereumChain',
            params: [
                {
                    chainId: ChainParams.ChainId,
                    chainName: ChainParams.ChainName,
                    rpcUrls: [ChainParams.RpcUrl],
                    blockExplorerUrls: [ChainParams.ExplorerUrl],
                },
            ],
        })
        .then((_res) => {
            // console.log('change network success')
            location.reload()
        })
        .catch((e) => {

        })
    }
}
