import { _decorator, Component, EditBox, Label, Node } from 'cc';
import { EthersUtils } from './EthersUtils';
import { ABI } from './ABI';
const { ccclass, property } = _decorator;

@ccclass('Main')
export class Main extends Component {
    @property(Label)
    myAddress:Label = null;
    @property(Node)
    connectNode : Node = null;
    @property(Node)
    controlNode : Node = null;

    @property(Label)
    myblanace:Label = null;
    @property(EditBox)
    transferAddress:EditBox = null;

    start() {
    }

    async onClickConnect(){
        var address = await EthersUtils.connectWallet()
        if(address != null){
            this.myAddress.string = address
            this.connectNode.active = false;
            this.controlNode.active = true;
        }
    }
    
    async onClickReadBalance(){
        
        //主币
        var mainBal = await EthersUtils.signer.getBalance()
        this.myblanace.string = "tBNB主币余额: "+ethers.utils.formatUnits(mainBal,18);
        // 代币
        /**
         * new ethers.Contract 三个入参分别为
         * 1、合约地址，当前使用USDT地址
         * 2、用前面复制下来的abi
         * 3、因为是读取所以直接使用公钥 provider
         */
        var contract = new ethers.Contract(EthersUtils.ChainParams.Token_USDTAddress,ABI.Token,EthersUtils.provider);
        var bal = await contract.balanceOf(EthersUtils.address);
        this.myblanace.string += "\nUSDT: "+ ethers.utils.formatUnits(bal,18);
    }

    async onClickTransfer(){
        //跟上面不一样的是，要使用私钥
        var contract = new ethers.Contract(EthersUtils.ChainParams.Token_USDTAddress,ABI.Token,EthersUtils.signer);
        //这里要特别注意单位，一般的代币小数位都是18位，所以我们得把0.1转为18位小数的bignumber
        var v1 = await contract.transfer(this.transferAddress.string,ethers.utils.parseUnits("0.1",18));
        //操作完成 等待服务器同步完成
        var result = await v1.wait(2);
        console.log("转账完成:",result)
    }


    update(deltaTime: number) {
        
    }
}


