import AItemRenderer from "../AItemRenerer";

const { ccclass, property } = cc._decorator;

const color = new cc.Color(255, 207, 155, 255);

@ccclass('ItemAutoSize')
export class ItemAutoSize extends AItemRenderer<string> {
    protected dataChanged(): void {
        cc.find("lblName", this.node).getComponent(cc.Label).string = this.data;
        let h = Math.floor(80 + Math.random() * 100);
        let w = Math.floor(80 + Math.random() * 100);
        this["h_" + this.data] = this["h_" + this.data] ?? h;
        this["w_" + this.data] = this["w_" + this.data] ?? w;
        if (!this["c_" + this.data]) {
            color.r = 255 * Math.random();
            color.g = 255 * Math.random();
            color.b = 255 * Math.random();
            this["c_" + this.data] = color.clone();
        }
        this.node.color = this["c_" + this.data];
        this.node.setContentSize(this["w_" + this.data], this["h_" + this.data]);
    }

}


