

        // javascript:!(
        //     function() {
        //         var cdom = document.createElement("canvas");
        //         cdom.id = "myCanvas";
        //         cdom.style.position="fixed";
        //         cdom.style.left = "0";
        //         cdom.style.top = "0";
        //         cdom.style.zIndex=-1;
        //         document.body.appendChild(cdom);
        //         var canvas = document.getElementById('myCanvas');
        //         var context = canvas.getContext('2d');
        //         function resizeCanvas() {
        //             canvas.width = window.innerWidth;
        //             canvas.height = window.innerHeight;
        //         }
        //         window.addEventListener('resize', resizeCanvas, false);
        //         resizeCanvas();
        //         clearCanvas();
        //         function clearCanvas(){
        //             context.fillStyle = '#000000';
        //             context.fillRect(0,0,canvas.width, canvas.height);
        //         }
        //         function mouseDownHandler(e) {
        //             var x = e.clientX;
        //             var y = e.clientY;
        //             fire(x,y);
        //         }
        //         var rid;
        //         function fire(x,y){
        //             createFireworks(x,y);
        //             function tick() {
        //                 context.globalCompositeOperation = 'destination-out';
        //                 context.fillStyle = 'rgba(0,0,0,'+10/100+')';
        //                 context.fillRect(0,0,canvas.width,canvas.height);
        //                 context.globalCompositeOperation = 'lighter';
        //                 drawFireworks();
        //                 rid=requestAnimationFrame(tick);
        //             }
        //             cancelAnimationFrame(rid);
        //             tick();
        //         }
        //         var particles=[];
        //         function createFireworks(sx,sy){
        //             particles=[];
        //             var hue = Math.floor(Math.random()*51)+150;
        //             var hueVariance = 30;
        //             var count = 100;
        //             for(var i = 0 ;i<count;i++){
        //                 var p = {};
        //                 var angle = Math.floor(Math.random()*360);
        //                 p.radians = angle * Math.PI / 180;
        //                 p.x = sx;
        //                 p.y = sy;
        //                 p.speed = (Math.random()*5)+.4;
        //                 p.radius = p.speed;
        //                 p.size = Math.floor(Math.random()*3)+1;
        //                 p.hue = Math.floor(Math.random()*2*hueVariance)+(hue-hueVariance);
        //                 p.brightness = Math.floor(Math.random()*31)+50;
        //                 p.alpha = (Math.floor(Math.random()*61)+40)/100;
        //                 particles.push(p);
        //             }
        //         }
        //         function drawFireworks() {
        //             clearCanvas();
        //             for(var i = 0 ;i<particles.length;i++){
        //                 var p = particles[i];
        //                 var vx = Math.cos(p.radians) * p.radius;
        //                 var vy = Math.sin(p.radians) * p.radius + 0.4;
        //                 p.x += vx;p.y += vy;p.radius *= 1 - p.speed/100;
        //                 p.alpha -= 0.005;
        //                 context.beginPath();
        //                 context.arc(p.x, p.y, p.size, 0, Math.PI*2, false);
        //                 context.closePath();
        //                 context.fillStyle = 'hsla('+p.hue+', 100%, '+p.brightness+'%, '+p.alpha+')';
        //                 context.fill();
        //             }
        //         }
        //         document.addEventListener('mousedown', mouseDownHandler, false);
        //     })();


const {ccclass, property} = cc._decorator;
@ccclass
export default class FireComponent extends cc.Component {
    @property
    isWidget: boolean = false;
    @property(cc.Node)
    _widgetTarget: cc.Node = null;
    @property(cc.Node)
    public get widgetTarget () {
        return this._widgetTarget;
    }
    public set widgetTarget (value) {
        this._widgetTarget = value;
        this.isWidget = !!this._widgetTarget;
        if (!CC_EDITOR) {
            this.initWidgit();
        }
    }

    private gfx: cc.Graphics = null;
    private particles: any[] = [];
    onLoad () {
        this.gfx = this.node.addComponent(cc.Graphics);

        // widgit
        this.initWidgit();
        // touch
        this.initTouch();
    }

    onDestroy () {

    }

    private initWidgit () {
        // 全屏适配
        if (!this.isWidget) return;
        let canvas = cc.find("Canvas");
        let widget = this.node.addComponent(cc.Widget);
        widget.target = this.widgetTarget || canvas;
        widget.isAlignTop = true;
        widget.isAlignLeft = true;
        widget.isAlignRight = true;
        widget.isAlignBottom = true;
        widget.left = 0;
        widget.right = 0;
        widget.top = 0;
        widget.bottom = 0;
        widget.alignMode = cc.Widget.AlignMode.ON_WINDOW_RESIZE;
    }

    private initTouch () {
        // 点击事件
        this.node.on(cc.Node.EventType.TOUCH_END, (event: cc.Event.EventTouch)=>{
            let wpos = event.getLocation();
            let npos = this.node.convertToNodeSpaceAR(wpos);
            this.fire(npos.x, npos.y);
        })
    }

    private fire (x, y) {
        // 生成烟花
        this.createFireworks(x, y);
    }

    private tick () {
        this.drawFireworks();
    }

    private createFireworks (sx, sy) {
        this.particles=[];
        var hue = Math.floor(Math.random()*51)+150;
        var hueVariance = 30;
        var count = 100;
        for(var i = 0 ;i<count;i++){
            var angle = Math.floor(Math.random()*360);
            var p = {
                radians: angle * Math.PI / 180,
                x: sx,
                y: sy,
                speed: (Math.random()*5)+.4,
                radius: 0,
                size: Math.floor(Math.random()*3)+1,
                hue: Math.floor(Math.random()*2*hueVariance)+(hue-hueVariance),
                brightness: Math.floor(Math.random()*31)+50,
                alpha: (Math.floor(Math.random()*61)+40)/100
            };
            p.radius = p.speed;
            this.particles.push(p);
        }
    }

    private drawFireworks () {
        this.gfx.clear();
        for(var i = 0 ;i<this.particles.length;i++){
            var p = this.particles[i];
            var vx = Math.cos(p.radians) * p.radius;
            var vy = Math.sin(p.radians) * p.radius + 0.4;
            p.x -= vx;
            p.y -= vy;
            p.radius *= 1 - p.speed/100;
            p.alpha -= 0.005;
            if (p.alpha > 0) {
                this.gfx.arc(p.x, p.y, p.size, 0, Math.PI*2, false);
                this.gfx.fillColor = this.hsla2rgba('hsla('+p.hue+', 100%, '+p.brightness+'%)', p.alpha);
                this.gfx.fill();
            }
        }
    }

    private hsla2rgba (str, alpha): cc.Color {
        const colorArr = str.match(/\d+/g);
        let [h, s, l] = colorArr;
        h = parseFloat(h) / 360;  
        s = parseFloat(s) / 100;  
        l = parseFloat(l) / 100;
        if (s === 0) {    
            l = Math.round(l * 255);
            return cc.color(l, l, l, Math.round(alpha * 255));
        }  
        const getRGB = num => {    
            let q = l >= 0.5 ? l + s - l * s : l * (1 + s); // 注意是数字1加上s，不是字母l
            let p = 2 * l - q;    
            if (num < 0) {      
                num += 1;    
            }    
            if (num > 1) {     
                num -= 1;    
            }    
            switch (true) {      
                case num > 2 / 3:        
                num = p;
                break;
                case num >= 1 / 2:
                num = p + (q - p) * 6 * (2 / 3 - num);
                break;
                case num >= 1 / 6:
                num = q;        
                break;      
                default:        
                num = p + (q - p) * 6 * num;        
                break;    
            }    
            return Math.round(num * 255);  
        };  
        let r = getRGB(h + 1 / 3);  
        let g = getRGB(h);  
        let b = getRGB(h - 1 / 3);
        return cc.color(r, g, b, Math.round(alpha * 255));
    }

    update () {
        this.tick();
    }
}