const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {
    @property(cc.Sprite)
    spr: cc.Sprite = null;

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    start () {
        // init logic
        this.label.string = this.text;

        cc.assetManager.loadRemote(this.getUrl(), {ext: '.jpg'}, (err, texture:cc.Texture2D)=>{
            this.spr.spriteFrame = new cc.SpriteFrame(texture);
        })
    }

    getUrl() :string{
        return `data:image/jpg;base64,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`
    }
}
