import { _decorator, Component, BufferAsset, Label } from 'cc';
const { ccclass, property } = _decorator;
import __wbg_init, { initSync } from "db://assets/scripts/ns";
import * as ns from "db://assets/scripts/ns";

@ccclass('WasmTest')
export class WasmTest extends Component {

    @property({ type: Label })
    public label: Label;

    @property({ type: BufferAsset })
    public netWasm: BufferAsset;

    start() {
        console.log('load wasm_buffer');
        let wasm_buffer: ArrayBuffer | string = this.netWasm?.buffer();
        __wbg_init(wasm_buffer).then(() => {
            this.label.string = `get random value: ${ns.n()}`;
        });
    }

    update(deltaTime: number) {
        
    }
}

