const { ccclass, property } = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.JsonAsset)
    private 贝塞尔曲线Asset: cc.JsonAsset = null;

    private reserve: cc.Node;
    private imgs: Array<cc.Node>;
    private 画板: cc.Node;
    private w2: number;
    private h2: number;
    private drawCamera: cc.Camera;
    private circle: cc.Node;
    private pen: cc.Node;

    protected start(): void {
        const 贝塞尔曲线s: { [key: string]: Array<Array<"M" | "L" | "Q" | number>> } = this.贝塞尔曲线Asset.json;
        const seg = 10;//折线长度
        const xysss: { [key: string]: Array<Array<Array<number>>> } = {};
        let i: number;
        let L: number;
        let _xys: Array<number>;
        let xStart: number;
        let yStart: number;
        let xEnd: number;
        let yEnd: number;
        for (const key in 贝塞尔曲线s) {
            const lines = 贝塞尔曲线s[key];
            const xyss: Array<Array<Array<number>>> = xysss[key] = [];
            for (const line of lines) {
                const xys: Array<Array<number>> = [];
                xyss.push(xys);
                i = 0;
                L = line.length;
                _xys = null;
                while (i < L) {
                    switch (line[i]) {
                        case "M":
                            i++;
                            xys.push(_xys = [xStart = line[i++] as number, yStart = line[i++] as number]);
                            break;
                        case "L":
                            i++;
                            xEnd = line[i++] as number;
                            yEnd = line[i++] as number;
                            const dx = xEnd - xStart;
                            const dy = yEnd - yStart;
                            const len = Math.sqrt(dx * dx + dy * dy);
                            if (len > 1) {
                                const count = Math.ceil(len / seg);
                                for (let j: number = 1; j <= count; j++) {
                                    const k = j / count;
                                    _xys.push(xStart + dx * k, yStart + dy * k);
                                }
                            } else {
                                _xys.push(xEnd, yEnd);
                            }
                            break;
                        case "Q":
                            i++;
                            while (!isNaN(line[i] as number)) {
                                const xCtrl = line[i++] as number;
                                const yCtrl = line[i++] as number;
                                xEnd = line[i++] as number;
                                yEnd = line[i++] as number;

                                const dx1 = xCtrl - xStart;
                                const dy1 = yCtrl - yStart;
                                const dx2 = xEnd - xCtrl;
                                const dy2 = yEnd - yCtrl;
                                const len = Math.sqrt(dx1 * dx1 + dy1 * dy1) + Math.sqrt(dx2 * dx2 + dy2 * dy2);//粗略估算一下长度
                                if (len > 1) {
                                    const count = Math.ceil(len / seg);
                                    for (let j: number = 1; j <= count; j++) {
                                        const k = j / count;
                                        const rk = 1 - k;
                                        _xys.push(
                                            rk * rk * xStart + 2 * rk * k * xCtrl + k * k * xEnd,
                                            rk * rk * yStart + 2 * rk * k * yCtrl + k * k * yEnd
                                        );
                                    }
                                } else {
                                    _xys.push(xEnd, yEnd);
                                }

                                xStart = xEnd;
                                yStart = yEnd;
                            }
                            break;
                        default:
                            console.error("暂不支持：" + line[i]);
                            i++;
                            break;
                    }
                }
            }
        }

        this.reserve = this.node.getChildByName("reserve");
        const mask = this.node.getChildByName("mask").getComponent(cc.Mask);
        this.imgs = mask.node.children.slice();
        for (const img of this.imgs) {
            img.active = false;
        }
        this.画板 = this.node.getChildByName("画板");
        const texture = new cc.RenderTexture();
        texture.initWithSize(this.画板.width, this.画板.height);
        const sf = new cc.SpriteFrame(texture);
        mask.spriteFrame = sf;
        this.node.getChildByName("只是用来显示笔迹").getComponent(cc.Sprite).spriteFrame = sf;
        this.w2 = this.画板.width / 2;
        this.h2 = this.画板.height / 2;
        this.circle = this.画板.getChildByName("content")/* content只是为了scaleX=-1 */.getChildByName("circle");
        this.drawCamera = this.画板.getChildByName("camera").getComponent(cc.Camera);
        this.drawCamera.ortho = true;
        this.drawCamera.alignWithScreen = false;
        this.drawCamera.orthoSize = this.h2;
        this.drawCamera.targetTexture = texture;
        this.pen = this.node.getChildByName("pen");
        this.draw(xysss["dora"]);
    }
    private draw(xyss: Array<Array<Array<number>>>): void {
        let i: number = -1;
        let xys: Array<Array<number>>;
        let j: number;
        let _xys: Array<number>;
        let k: number;
        const nextLine = () => {
            if (++i < xyss.length) {
                this.circle.x = -10000;
                this.drawCamera.clearFlags = cc.Camera.ClearFlags.COLOR;
                this.drawCamera.render();
                this.drawCamera.clearFlags = 0;
                const img = this.imgs[i];
                img.active = true;
                img.color = new cc.Color(Math.random() * 256, Math.random() * 256, Math.random() * 256);
                xys = xyss[i];
                j = -1;
                nextXYs();
            } else {
                this.pen.active = false;
                console.log("搞定！");
            }
        };
        const nextXYs = () => {
            if (++j < xys.length) {
                _xys = xys[j];
                k = 0;
                const x = _xys[k++] - this.w2;
                const y = -_xys[k++] + this.h2;
                const dx = x - this.pen.x;
                const dy = y - this.pen.y;
                const t = Math.sqrt(dx * dx + dy * dy) / 1000;
                this.pen.runAction(cc.sequence(
                    cc.moveTo(t > 0.1 ? t : 0.1, x, y).easing(cc.easeExponentialInOut()),
                    cc.callFunc(() => {
                        this.circle.x = x;
                        this.circle.y = y;
                        nextP();
                    })
                ));
            } else {
                const img = this.imgs[i];
                img.parent.removeChild(img, false);
                this.reserve.addChild(img);
                nextLine();
            }
        };
        const nextP = () => {
            if (k < _xys.length) {
                this.pen.x = this.circle.x = _xys[k++] - this.w2;
                this.pen.y = this.circle.y = -_xys[k++] + this.h2;
                this.scheduleOnce(() => {
                    nextP();
                });
            } else {
                nextXYs();
            }
        };
        nextLine();
    }
}
