const fs = require("fs");

const 贝塞尔曲线s = {};
for (const path of fs.readdirSync(".", { recursive: true })) {
  if (path.endsWith(".svg")) {
    const datas = 贝塞尔曲线s[path.replace(/\.svg$/, "")] = [];
    for (const line of fs.readFileSync(path, "utf8").replace(/\r/g, "").match(/ d="[^"]+"/g)) {
      // M (moveto): 移动到指定点，不画线。
      // <path d="M 50 50" />
      // L (lineto): 从当前位置画一条直线到指定点。
      // <path d="M 50 50 L 150 50" stroke="black" />
      // H/V (horizontal/vertical lineto): 绘制水平或垂直线。
      // <path d="M 50 50 H 150 V 100" stroke="blue" />
      // C (curveto): 三次贝塞尔曲线，需要两个控制点和一个终点。
      // <path d="M 10 80 C 40 10, 65 10, 95 80" stroke="red" fill="none" />
      // Q (quadratic Bézier curve): 二次贝塞尔曲线，需要一个控制点和一个终点。
      // <path d="M 10 80 Q 95 10, 180 80" stroke="green" fill="none" />
      // A (arc): 椭圆弧，需要半径、旋转角度、方向等参数。
      // <path d="M 50 150 A 30 50, 0, 0, 1, 150 150" stroke="purple" fill="none" />
      // Z (closepath): 闭合路径，从当前点画线回到起点。
      const data = [];
      for (const str of line.match(/"([^"]+)"/)[1].replace(/^\s*|\s*$/g, "").split(/\s+/)) {
        const num = parseFloat(str);
        if (isNaN(num)) {
          switch (str) {
            case "M":
            case "L":
            case "Q":
              data.push(str);
              break;
            case "Z":
              break;
            default:
              console.error("暂不支持：" + str);
              break;
          }
        } else {
          data.push(Math.round(num * 100) / 100);
        }
      }
      datas.push(data);
    }
  }
}
const jsonPath = "../demo/assets/贝塞尔曲线s.json";
fs.writeFileSync(jsonPath, JSON.stringify(贝塞尔曲线s).replace(/\["M/g, "\n[\"M").replace(/\]\],/g, "]],\n"));
console.log("输出至：" + jsonPath);