/****************************************************************************
 Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.
 
 http://www.cocos2d-x.org
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 ****************************************************************************/

#include "AppDelegate.h"
#include "HelloWorldScene.h"
#include "SensorsAnalytics/SensorsAnalytics/include/SensorsAnalytics.h"
#include "SensorsAnalytics/SensorsAnalytics/include/ObjectNode.h"

// #define USE_AUDIO_ENGINE 1
// #define USE_SIMPLE_AUDIO_ENGINE 1

#if USE_AUDIO_ENGINE && USE_SIMPLE_AUDIO_ENGINE
#error "Don't use AudioEngine and SimpleAudioEngine at the same time. Please just select one in your game!"
#endif

#if USE_AUDIO_ENGINE
#include "audio/include/AudioEngine.h"
using namespace cocos2d::experimental;
#elif USE_SIMPLE_AUDIO_ENGINE
#include "audio/include/SimpleAudioEngine.h"
using namespace CocosDenshion;
#endif

USING_NS_CC;
using namespace sensorsdata;
static cocos2d::Size designResolutionSize = cocos2d::Size(480, 320);
static cocos2d::Size smallResolutionSize = cocos2d::Size(480, 320);
static cocos2d::Size mediumResolutionSize = cocos2d::Size(1024, 768);
static cocos2d::Size largeResolutionSize = cocos2d::Size(2048, 1536);

AppDelegate::AppDelegate()
{
}

AppDelegate::~AppDelegate() 
{
#if USE_AUDIO_ENGINE
    AudioEngine::end();
#elif USE_SIMPLE_AUDIO_ENGINE
    SimpleAudioEngine::end();
#endif
}
#include <iostream>
using namespace std;
// if you want a different context, modify the value of glContextAttrs
// it will affect all platforms
void AppDelegate::initGLContextAttrs()
{
    // set OpenGL context attributes: red,green,blue,alpha,depth,stencil,multisamplesCount
    GLContextAttrs glContextAttrs = {8, 8, 8, 8, 24, 8, 0};

    GLView::setGLContextAttrs(glContextAttrs);
}

// if you want to use the package manager to install more packages,  
// don't modify or remove this function
static int register_all_packages()
{
    return 0; //flag for packages manager
}

bool AppDelegate::applicationDidFinishLaunching() {
    // initialize director
    auto director = Director::getInstance();
    auto glview = director->getOpenGLView();
    if(!glview) {
#if (CC_TARGET_PLATFORM == CC_PLATFORM_WIN32) || (CC_TARGET_PLATFORM == CC_PLATFORM_MAC) || (CC_TARGET_PLATFORM == CC_PLATFORM_LINUX)
        glview = GLViewImpl::createWithRect("MyCppGame", cocos2d::Rect(0, 0, designResolutionSize.width, designResolutionSize.height));
#else
        glview = GLViewImpl::create("MyCppGame");
#endif
        director->setOpenGLView(glview);
    }

    // turn on display FPS
    director->setDisplayStats(true);

    // set FPS. the default value is 1.0/60 if you don't call this
    director->setAnimationInterval(1.0f / 60);

    // Set the design resolution
    glview->setDesignResolutionSize(designResolutionSize.width, designResolutionSize.height, ResolutionPolicy::NO_BORDER);
    auto frameSize = glview->getFrameSize();
    // if the frame's height is larger than the height of medium size.
    if (frameSize.height > mediumResolutionSize.height)
    {        
        director->setContentScaleFactor(MIN(largeResolutionSize.height/designResolutionSize.height, largeResolutionSize.width/designResolutionSize.width));
    }
    // if the frame's height is larger than the height of small size.
    else if (frameSize.height > smallResolutionSize.height)
    {        
        director->setContentScaleFactor(MIN(mediumResolutionSize.height/designResolutionSize.height, mediumResolutionSize.width/designResolutionSize.width));
    }
    // if the frame's height is smaller than the height of medium size.
    else
    {        
        director->setContentScaleFactor(MIN(smallResolutionSize.height/designResolutionSize.height, smallResolutionSize.width/designResolutionSize.width));
    }

    register_all_packages();

    // create a scene. it's an autorelease object
    auto scene = HelloWorld::createScene();

    // run
    director->runWithScene(scene);
//    umeng::MobClickCpp::event("Forward");

//    SensorsAnalytics::login("2222");
//    SensorsAnalytics::track();
//    SensorsAnalytics::track("acv");

    SensorsAnalytics::setFlushNetworkPolicy(FlushNetworkPolicy::kFlush4G|FlushNetworkPolicy::kFlush5G|FlushNetworkPolicy::kFlushWiFi);
    sensorsdata::ObjectNode pro;
    pro.setBool("bool", true);
    pro.setString("str","string");
    pro.setString("$lib_plugin_version","aaa");
    SensorsAnalytics::track("Go", pro);
////
//
    sensorsdata::ObjectNode eventProperties;
    eventProperties.setString("ProductCatalog", "Laptop Computer");
    eventProperties.setNumber("ProductID", 3);
    eventProperties.setNumber("ProductPrice", 3.14);
    eventProperties.setBool("IsVIP", true);
    eventProperties.setDateTime("BuyTime", time(NULL), 0);
    std::vector<std::string> shoppingCar;
    shoppingCar.push_back("MacBook");
    shoppingCar.push_back("AirPodsMax");
    eventProperties.setList("ShoppingCart", shoppingCar);
    // SensorsAnalytics::track("BuyProduct", NULL);

    sensorsdata::SensorsAnalytics::track("BuyProduct", eventProperties);
//    log("线程开始");
//    std::chrono::milliseconds dura(2000);
//    std::this_thread::sleep_for(dura);
//    log("线程结束");
    sensorsdata::SensorsAnalytics::trackAppInstall();
//
////    SensorsAnalytics::flush();
//    string js = ObjectNode::toJson(eventProperties);
////    log("string is %s",js.c_str());
//
//
//    std::string test_string = "测试字符串";
//    eventProperties.setString("test_stl_string", test_string);
//    SensorsAnalytics::setFlushNetworkPolicy(
//            sensorsdata::kFlush4G);

    sensorsdata::SensorsAnalytics::login("1111");



    sensorsdata::SensorsAnalytics::track("acv");

    sensorsdata::SensorsAnalytics::logout();
//
    string s = SensorsAnalytics::getSuperProperties();
//
    log("superproperties is %s", s.c_str());

    string start =  sensorsdata::SensorsAnalytics::trackTimerStart("timerstart");
    log("trackTimerStart is %s", start.c_str());

//
//    cout<<"super"<<s.c_str()<<endl;
//    printf("%s",s.c_str());
//
//
//    SensorsAnalytics::identify("ccc");
////    SensorsAnalytics::login("login");
//    SensorsAnalytics::track("track");
////    SensorsAnalytics::logout();
    sensorsdata::ObjectNode eventProperties1;
    eventProperties1.setString("age", "Laptop Computer");
    sensorsdata::SensorsAnalytics::profileSet(eventProperties1);
    sensorsdata::ObjectNode eventProperties2;
    eventProperties2.setString("cocos2d", "aaa");
    sensorsdata::SensorsAnalytics::registerSuperProperties(eventProperties2);
//
////    SensorsAnalytics::unregisterSuperProperty("reyuejianzhong");
////    SensorsAnalytics::clearSuperProperties();
//    SensorsAnalytics::profileSetOnce(eventProperties2);
//    SensorsAnalytics::trackAppInstall(eventProperties2, false);
////
//////    SensorsAnalytics::deleteAll();
//    SensorsAnalytics::itemSet("type","id",eventProperties2);
//    SensorsAnalytics::itemDelete("itype","tid");
    return true;
}

// This function will be called when the app is inactive. Note, when receiving a phone call it is invoked.
void AppDelegate::applicationDidEnterBackground() {
    Director::getInstance()->stopAnimation();

#if USE_AUDIO_ENGINE
    AudioEngine::pauseAll();
#elif USE_SIMPLE_AUDIO_ENGINE
    SimpleAudioEngine::getInstance()->pauseBackgroundMusic();
    SimpleAudioEngine::getInstance()->pauseAllEffects();
#endif
}

// this function will be called when the app is active again
void AppDelegate::applicationWillEnterForeground() {
    Director::getInstance()->startAnimation();

#if USE_AUDIO_ENGINE
    AudioEngine::resumeAll();
#elif USE_SIMPLE_AUDIO_ENGINE
    SimpleAudioEngine::getInstance()->resumeBackgroundMusic();
    SimpleAudioEngine::getInstance()->resumeAllEffects();
#endif
}
